/*
 * Decompiled with CFR 0.152.
 */
package org.bounce.wizard;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import org.bounce.CardPanel;
import org.bounce.QDialog;
import org.bounce.QPanel;
import org.bounce.wizard.WizardPage;
import org.bounce.wizard.WizardPageEvent;
import org.bounce.wizard.WizardPageListener;

public abstract class Wizard
extends QDialog
implements WizardPageListener {
    private static final long serialVersionUID = 7119005231853816073L;
    private JLabel titleLabel = null;
    private JLabel descriptionLabel = null;
    private JLabel iconLabel = null;
    private CardPanel<WizardPage> cards = null;
    private JButton nextButton = null;
    private JButton backButton = null;
    private JButton finishButton = null;
    private JButton cancelButton = null;

    public Wizard(Frame parent) {
        super(parent, true);
        this.createCenterPanel();
        QPanel header = new QPanel(new BorderLayout());
        header.setGradientBackground(true);
        header.setGradientColor(this.getGradientColor());
        header.setBackground(Color.white);
        header.setOpaque(true);
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(2, 1));
        this.titleLabel = new JLabel();
        this.titleLabel.setBorder(new EmptyBorder(0, 10, 0, 0));
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1, 14.0f));
        this.descriptionLabel = new JLabel();
        this.descriptionLabel.setBorder(new EmptyBorder(5, 20, 5, 10));
        this.descriptionLabel.setFont(this.descriptionLabel.getFont().deriveFont(0));
        panel.add(this.titleLabel);
        panel.add(this.descriptionLabel);
        panel.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel info = new JPanel();
        info.setLayout(new BorderLayout());
        info.add((Component)panel, "Center");
        this.iconLabel = new JLabel();
        this.iconLabel.setBorder(new EmptyBorder(5, 5, 5, 5));
        panel.setOpaque(false);
        info.setOpaque(false);
        header.add((Component)this.iconLabel, "East");
        header.add((Component)info, "Center");
        header.setBorder(new MatteBorder(0, 0, 1, 0, UIManager.getColor("controlDkShadow")));
        JPanel centerPanel = this.createCenterPanel();
        centerPanel.add((Component)header, "North");
        centerPanel.add(this.getCards(), "Center");
        centerPanel.add((Component)this.createSouthPanel(), "South");
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.add((Component)centerPanel, "Center");
        this.setContentPane(contentPane);
    }

    protected JPanel createCenterPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        return panel;
    }

    protected JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.add(this.getBackButton());
        buttonPanel.add(this.getNextButton());
        buttonPanel.add(this.getFinishButton());
        buttonPanel.add(this.getCancelButton());
        return buttonPanel;
    }

    protected JPanel createSouthPanel() {
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.setBorder(new CompoundBorder(new MatteBorder(1, 0, 0, 0, UIManager.getColor("controlDkShadow")), new EmptyBorder(5, 5, 5, 5)));
        southPanel.add((Component)this.createButtonPanel(), "East");
        return southPanel;
    }

    protected CardPanel<WizardPage> getCards() {
        if (this.cards == null) {
            this.cards = new CardPanel();
        }
        return this.cards;
    }

    protected JButton getFinishButton() {
        if (this.finishButton == null) {
            this.finishButton = new JButton("Finish");
            this.finishButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    Wizard.this.close();
                }
            });
            this.finishButton.setMnemonic('F');
        }
        return this.finishButton;
    }

    protected JButton getNextButton() {
        if (this.nextButton == null) {
            this.nextButton = new JButton("Next");
            this.nextButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    Wizard.this.nextPage();
                }
            });
            this.nextButton.setMnemonic('N');
        }
        return this.nextButton;
    }

    protected JButton getBackButton() {
        if (this.backButton == null) {
            this.backButton = new JButton("Back");
            this.backButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    Wizard.this.backPage();
                }
            });
            this.backButton.setMnemonic('B');
            this.backButton.setEnabled(false);
        }
        return this.backButton;
    }

    protected JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    Wizard.this.cancel();
                }
            });
        }
        return this.cancelButton;
    }

    private Color getGradientColor() {
        Color color = UIManager.getColor("Button.focus");
        if (color == null) {
            return new JPanel().getBackground();
        }
        while ((color.getBlue() + color.getRed() + color.getGreen()) / 3 < 128) {
            color = color.brighter();
        }
        return color;
    }

    public void addPage(WizardPage page) {
        this.cards.add(page);
    }

    protected abstract String getWizardTitle();

    @Override
    public void setTitle(String title) {
        super.setTitle(this.getWizardTitle() + " - " + title);
        this.titleLabel.setText(title);
    }

    public void setDescription(String description) {
        this.descriptionLabel.setText(description);
    }

    public void backPage() {
        WizardPage page = this.cards.selected();
        this.setPage(page.getBack());
    }

    public void nextPage() {
        WizardPage page = this.cards.selected();
        WizardPage next = page.getNext();
        next.setBack(page);
        this.setPage(next);
    }

    protected void setPage(WizardPage page) {
        if (this.cards.selected() != null) {
            this.cards.selected().removeWizardPageListener(this);
        }
        this.cards.show(page);
        this.setTitle(page.getTitle());
        this.setDescription(page.getDescription());
        this.backButton.setEnabled(page.getBack() != null);
        if (page.getNext() != null) {
            this.nextButton.setEnabled(true);
            this.getRootPane().setDefaultButton(this.nextButton);
        } else {
            this.nextButton.setEnabled(false);
            this.getRootPane().setDefaultButton(this.finishButton);
        }
        page.addWizardPageListener(this);
    }

    public WizardPage getPage() {
        return this.cards.selected();
    }

    @Override
    public void pageChanged(WizardPageEvent event) {
        this.setPage((WizardPage)event.getSource());
    }
}

