/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.common.base.SystemUtils;
import com.jgoodies.looks.MicroLayout;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticXPBorders;
import com.jgoodies.looks.plastic.PlasticXPIconFactory;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.UIDefaults;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.InsetsUIResource;

public final class PlasticXPLookAndFeel
extends PlasticLookAndFeel {
    @Override
    public String getName() {
        return "JGoodies Plastic XP";
    }

    @Override
    public String getDescription() {
        return "The JGoodies Plastic XP Look and Feel";
    }

    @Override
    protected boolean is3DEnabled() {
        return true;
    }

    @Override
    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        String uiClassnamePrefix = "com.jgoodies.looks.plastic.PlasticXP";
        Object[] uiDefaults = new Object[]{"SpinnerUI", "com.jgoodies.looks.plastic.PlasticXPSpinnerUI", "ToolBarUI", "com.jgoodies.looks.plastic.PlasticXPToolBarUI"};
        table.putDefaults(uiDefaults);
    }

    @Override
    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        MicroLayout microLayout = PlasticXPLookAndFeel.getMicroLayoutPolicy().getMicroLayout(this.getName(), table);
        Insets buttonBorderInsets = microLayout.getButtonBorderInsets();
        Border buttonBorder = PlasticXPBorders.getButtonBorder(buttonBorderInsets);
        Border toggleButtonBorder = PlasticXPBorders.getToggleButtonBorder(buttonBorderInsets);
        Icon checkBoxIcon = PlasticXPIconFactory.getCheckBoxIcon();
        Border comboBoxButtonBorder = PlasticXPBorders.getComboBoxArrowButtonBorder();
        Border comboBoxEditorBorder = PlasticXPBorders.getComboBoxEditorBorder();
        Icon radioButtonIcon = PlasticXPIconFactory.getRadioButtonIcon();
        Border scrollPaneBorder = PlasticXPBorders.getScrollPaneBorder();
        Border textFieldBorder = PlasticXPBorders.getTextFieldBorder();
        Border spinnerBorder = PlasticXPBorders.getSpinnerBorder();
        String radioCheckIconName = SystemUtils.IS_LOW_RESOLUTION ? "icons/RadioLight5x5.png" : "icons/RadioLight7x7.png";
        InsetsUIResource comboEditorInsets = microLayout.getComboBoxEditorInsets();
        Insets comboEditorBorderInsets = comboBoxEditorBorder.getBorderInsets(null);
        int comboBorderSize = comboEditorBorderInsets.left;
        int comboPopupBorderSize = microLayout.getComboPopupBorderSize();
        int comboRendererGap = comboEditorInsets.left + comboBorderSize - comboPopupBorderSize;
        EmptyBorder comboRendererBorder = new EmptyBorder(1, comboRendererGap, 1, comboRendererGap);
        Insets comboTableEditorInsets = new Insets(0, 0, 0, 0);
        Object[] defaults = new Object[]{"Button.border", buttonBorder, "Button.borderPaintsFocus", Boolean.TRUE, "CheckBox.icon", checkBoxIcon, "CheckBox.check", PlasticXPLookAndFeel.getToggleButtonCheckColor(), "ComboBox.arrowButtonBorder", comboBoxButtonBorder, "ComboBox.editorBorder", comboBoxEditorBorder, "ComboBox.editorBorderInsets", comboEditorBorderInsets, "ComboBox.tableEditorInsets", comboTableEditorInsets, "ComboBox.rendererBorder", comboRendererBorder, "ComboBox.borderPaintsFocus", Boolean.TRUE, "FormattedTextField.border", textFieldBorder, "PasswordField.border", textFieldBorder, "Spinner.border", spinnerBorder, "ScrollPane.border", scrollPaneBorder, "Table.scrollPaneBorder", scrollPaneBorder, "RadioButton.icon", radioButtonIcon, "RadioButton.check", PlasticXPLookAndFeel.getToggleButtonCheckColor(), "RadioButton.interiorBackground", PlasticXPLookAndFeel.getControlHighlight(), "RadioButton.checkIcon", PlasticXPLookAndFeel.makeIcon(PlasticXPLookAndFeel.class, radioCheckIconName), "TextField.border", textFieldBorder, "ToggleButton.border", toggleButtonBorder, "ToggleButton.borderPaintsFocus", Boolean.TRUE, "Tree.expandedIcon", PlasticXPLookAndFeel.makeIcon(PlasticXPLookAndFeel.class, "icons/TreeExpanded.png"), "Tree.collapsedIcon", PlasticXPLookAndFeel.makeIcon(PlasticXPLookAndFeel.class, "icons/TreeCollapsed.png")};
        table.putDefaults(defaults);
    }

    private static ColorUIResource getToggleButtonCheckColor() {
        return PlasticXPLookAndFeel.getPlasticTheme().getToggleButtonCheckColor();
    }
}

