/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.common.base.SystemUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

public final class PlasticModernIconFactory {
    private static CheckBoxIcon checkBoxIcon;
    private static RadioButtonIcon radioButtonIcon;
    private static ComboBoxButtonIcon comboBoxButtonIcon;

    private PlasticModernIconFactory() {
    }

    static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    static Icon getRadioButtonIcon() {
        if (radioButtonIcon == null) {
            radioButtonIcon = new RadioButtonIcon();
        }
        return radioButtonIcon;
    }

    static Icon getComboBoxButtonIcon() {
        if (comboBoxButtonIcon == null) {
            comboBoxButtonIcon = new ComboBoxButtonIcon();
        }
        return comboBoxButtonIcon;
    }

    private static final class RadioButtonIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final int SIZE = SystemUtils.IS_LOW_RESOLUTION ? 13 : 15;

        private RadioButtonIcon() {
        }

        @Override
        public int getIconWidth() {
            return SIZE;
        }

        @Override
        public int getIconHeight() {
            return SIZE;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            AbstractButton rb = (AbstractButton)c;
            State state = State.valueOf(rb.getModel());
            String uiKey = state.radioKey();
            UIManager.getIcon(uiKey).paintIcon(c, g, x, y);
        }
    }

    private static final class CheckBoxIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final int SIZE = SystemUtils.IS_LOW_RESOLUTION ? 13 : 15;

        private CheckBoxIcon() {
        }

        @Override
        public int getIconWidth() {
            return SIZE;
        }

        @Override
        public int getIconHeight() {
            return SIZE;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            JCheckBox cb = (JCheckBox)c;
            State state = State.valueOf(cb.getModel());
            String uiKey = state.checkKey();
            UIManager.getIcon(uiKey).paintIcon(c, g, x, y);
        }
    }

    private static final class ComboBoxButtonIcon
    implements Icon,
    UIResource,
    Serializable {
        private ComboBoxButtonIcon() {
        }

        @Override
        public int getIconWidth() {
            return 8;
        }

        @Override
        public int getIconHeight() {
            return 4;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            JComponent jc = (JComponent)c;
            String suffix = jc.isEnabled() ? "enabled" : "disabled";
            UIManager.getIcon("ComboBox.arrowIcon." + suffix).paintIcon(c, g, x - 1, y);
        }
    }

    public static enum State {
        SELECTED_PLAIN("on-plain"),
        SELECTED_ROLLOVER("on-rollover"),
        SELECTED_PRESSED("on-pressed"),
        SELECTED_DISABLED("on-disabled"),
        DESELECTED_PLAIN("off-plain"),
        DESELECTED_ROLLOVER("off-rollover"),
        DESELECTED_PRESSED("off-pressed"),
        DESELECTED_DISABLED("off-disabled");

        private final String code;

        private State(String code) {
            this.code = code;
        }

        public String radioKey() {
            return this.uiKey("RadioButton");
        }

        public String checkKey() {
            return this.uiKey("CheckBox");
        }

        private String uiKey(String componentName) {
            StringBuilder builder = new StringBuilder(componentName);
            builder.append(".icon.");
            builder.append(this.code);
            return builder.toString();
        }

        public String iconPath(String lafName, String type) {
            StringBuilder builder = new StringBuilder("icons/");
            builder.append(lafName);
            builder.append('/');
            builder.append(type);
            builder.append('-');
            builder.append(this.code);
            builder.append(".png");
            return builder.toString();
        }

        static State valueOf(ButtonModel m) {
            if (!m.isEnabled()) {
                return m.isSelected() ? SELECTED_DISABLED : DESELECTED_DISABLED;
            }
            if (m.isArmed() && m.isPressed()) {
                return m.isSelected() ? SELECTED_PRESSED : DESELECTED_PRESSED;
            }
            if (m.isRollover()) {
                return m.isSelected() ? SELECTED_ROLLOVER : DESELECTED_ROLLOVER;
            }
            return m.isSelected() ? SELECTED_PLAIN : DESELECTED_PLAIN;
        }
    }
}

