/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.plastic.PlasticBorders;
import com.jgoodies.looks.plastic.PlasticComboBoxButton;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticModernUtils;
import com.jgoodies.looks.plastic.PlasticUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.metal.MetalBorders;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.JTextComponent;

final class PlasticModernBorders {
    private static Border comboBoxArrowButtonBorder;
    private static Border comboBoxEditorBorder;
    private static Border scrollPaneBorder;
    private static Border textFieldBorder;
    private static Border spinnerBorder;
    private static Border rolloverButtonBorder;

    private PlasticModernBorders() {
    }

    static Border getButtonBorder(Insets buttonMargin) {
        return new BorderUIResource.CompoundBorderUIResource(new ModernButtonBorder(buttonMargin), new BasicBorders.MarginBorder());
    }

    static Border getComboBoxArrowButtonBorder() {
        if (comboBoxArrowButtonBorder == null) {
            comboBoxArrowButtonBorder = new CompoundBorder(new ModernComboBoxArrowButtonBorder(), new BasicBorders.MarginBorder());
        }
        return comboBoxArrowButtonBorder;
    }

    static Border getComboBoxEditorBorder() {
        if (comboBoxEditorBorder == null) {
            comboBoxEditorBorder = new CompoundBorder(new ModernComboBoxEditorBorder(), new BasicBorders.MarginBorder());
        }
        return comboBoxEditorBorder;
    }

    static Border getScrollPaneBorder() {
        if (scrollPaneBorder == null) {
            scrollPaneBorder = new ModernScrollPaneBorder();
        }
        return scrollPaneBorder;
    }

    static Border getTextFieldBorder() {
        if (textFieldBorder == null) {
            textFieldBorder = new BorderUIResource.CompoundBorderUIResource(new ModernTextFieldBorder(), new BasicBorders.MarginBorder());
        }
        return textFieldBorder;
    }

    static Border getToggleButtonBorder(Insets buttonMargin) {
        return new BorderUIResource.CompoundBorderUIResource(new ModernButtonBorder(buttonMargin), new BasicBorders.MarginBorder());
    }

    static Border getSpinnerBorder() {
        if (spinnerBorder == null) {
            spinnerBorder = new ModernSpinnerBorder();
        }
        return spinnerBorder;
    }

    static Border getSpinnerButtonBorder() {
        return new ModernSpinnerButtonBorder();
    }

    static Border getRolloverButtonBorder() {
        if (rolloverButtonBorder == null) {
            rolloverButtonBorder = new CompoundBorder(new ModernRolloverButtonBorder(), new PlasticBorders.RolloverMarginBorder());
        }
        return rolloverButtonBorder;
    }

    private static boolean isSpinnerEditorTextFieldFocused(JSpinner c) {
        if (!(c.getEditor() instanceof JSpinner.DefaultEditor)) {
            return false;
        }
        JSpinner.DefaultEditor editor = (JSpinner.DefaultEditor)c.getEditor();
        return editor.getTextField().isFocusOwner();
    }

    private static boolean isTextEditorBorderPaintingFocus() {
        return UIManager.getBoolean("TextEditor.borderPaintsFocus");
    }

    private static final class ModernRolloverButtonBorder
    extends ModernButtonBorder {
        private ModernRolloverButtonBorder() {
            super(new Insets(3, 3, 3, 3));
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            AbstractButton b = (AbstractButton)c;
            ButtonModel model = b.getModel();
            if (!model.isEnabled()) {
                return;
            }
            if (!(c instanceof JToggleButton)) {
                if (model.isRollover() && (!model.isPressed() || model.isArmed())) {
                    super.paintBorder(c, g, x, y, w, h);
                }
                return;
            }
            if (model.isRollover()) {
                if (model.isPressed() && model.isArmed()) {
                    PlasticModernUtils.drawPressedButtonBorder(g, x, y, w, h);
                } else {
                    PlasticModernUtils.drawPlainButtonBorder(g, x, y, w, h);
                }
            } else if (model.isSelected()) {
                PlasticModernUtils.drawPressedButtonBorder(g, x, y, w, h);
            }
        }
    }

    static final class ModernSpinnerButtonBorder
    extends AbstractBorder {
        private static final Insets INSETS = new Insets(1, 1, 1, 1);

        ModernSpinnerButtonBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            Color color = !c.isEnabled() ? MetalLookAndFeel.getControlShadow() : (ModernSpinnerButtonBorder.isSpinnerFocused(c) && PlasticModernBorders.isTextEditorBorderPaintingFocus() ? PlasticModernUtils.LIGHT_BLUE : PlasticLookAndFeel.getControlDarkShadow());
            g.setColor(color);
            g.fillRect(x, y, 1, h - 1);
            g.fillRect(x + w - 1, y, 1, h - 1);
            g.fillRect(x, y + h - 1, w, 1);
            if ("Spinner.previousButton".equals(c.getName())) {
                g.setColor(PlasticLookAndFeel.getControl());
            }
            g.fillRect(x + 1, y, w - 2, 1);
        }

        private static boolean isSpinnerFocused(Component button) {
            Container parent = button.getParent();
            if (!(parent instanceof JSpinner)) {
                return false;
            }
            return PlasticModernBorders.isSpinnerEditorTextFieldFocused((JSpinner)parent);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return INSETS;
        }

        @Override
        public Insets getBorderInsets(Component c, Insets newInsets) {
            newInsets.top = ModernSpinnerButtonBorder.INSETS.top;
            newInsets.left = ModernSpinnerButtonBorder.INSETS.left;
            newInsets.bottom = ModernSpinnerButtonBorder.INSETS.bottom;
            newInsets.right = ModernSpinnerButtonBorder.INSETS.right;
            return newInsets;
        }
    }

    static final class ModernSpinnerBorder
    extends MetalBorders.ScrollPaneBorder {
        private static final Insets INSETS = new Insets(1, 1, 1, 1);

        ModernSpinnerBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            Color color = !c.isEnabled() ? MetalLookAndFeel.getControlShadow() : (PlasticModernBorders.isTextEditorBorderPaintingFocus() && PlasticModernBorders.isSpinnerEditorTextFieldFocused((JSpinner)c) ? PlasticModernUtils.LIGHT_BLUE : PlasticLookAndFeel.getControlDarkShadow());
            g.setColor(color);
            int arrowButtonWidth = UIManager.getInt("ScrollBar.width") - 1;
            g.fillRect(x, y, w -= arrowButtonWidth, 1);
            g.fillRect(x, y + 1, 1, h - 1);
            g.fillRect(x + 1, y + h - 1, w - 1, 1);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return INSETS;
        }

        @Override
        public Insets getBorderInsets(Component c, Insets newInsets) {
            newInsets.top = ModernSpinnerBorder.INSETS.top;
            newInsets.left = ModernSpinnerBorder.INSETS.left;
            newInsets.bottom = ModernSpinnerBorder.INSETS.bottom;
            newInsets.right = ModernSpinnerBorder.INSETS.right;
            return newInsets;
        }
    }

    private static final class ModernScrollPaneBorder
    extends MetalBorders.ScrollPaneBorder {
        private static final Insets INSETS = new Insets(1, 1, 1, 1);

        private ModernScrollPaneBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.setColor(c.isEnabled() ? PlasticLookAndFeel.getControlDarkShadow() : MetalLookAndFeel.getControlShadow());
            PlasticUtils.drawRect(g, x, y, w - 1, h - 1);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return INSETS;
        }

        @Override
        public Insets getBorderInsets(Component c, Insets newInsets) {
            newInsets.top = ModernScrollPaneBorder.INSETS.top;
            newInsets.left = ModernScrollPaneBorder.INSETS.left;
            newInsets.bottom = ModernScrollPaneBorder.INSETS.bottom;
            newInsets.right = ModernScrollPaneBorder.INSETS.right;
            return newInsets;
        }
    }

    static final class ModernTextFieldBorder
    extends AbstractBorder {
        private static final Insets INSETS = new Insets(1, 1, 1, 1);

        ModernTextFieldBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            boolean enabled;
            boolean bl = enabled = c.isEnabled() && (!(c instanceof JTextComponent) || ((JTextComponent)c).isEditable());
            Color color = !enabled ? MetalLookAndFeel.getControlShadow() : (c.isFocusOwner() && PlasticModernBorders.isTextEditorBorderPaintingFocus() ? PlasticModernUtils.LIGHT_BLUE : PlasticLookAndFeel.getControlDarkShadow());
            g.setColor(color);
            PlasticUtils.drawRect(g, x, y, w - 1, h - 1);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return INSETS;
        }

        @Override
        public Insets getBorderInsets(Component c, Insets newInsets) {
            newInsets.top = ModernTextFieldBorder.INSETS.top;
            newInsets.left = ModernTextFieldBorder.INSETS.left;
            newInsets.bottom = ModernTextFieldBorder.INSETS.bottom;
            newInsets.right = ModernTextFieldBorder.INSETS.right;
            return newInsets;
        }
    }

    static final class ModernComboBoxEditorBorder
    extends AbstractBorder {
        private static final Insets INSETS = new Insets(1, 1, 1, 0);

        ModernComboBoxEditorBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            Color color = !c.isEnabled() ? MetalLookAndFeel.getControlShadow() : (c.isFocusOwner() && PlasticModernBorders.isTextEditorBorderPaintingFocus() ? PlasticModernUtils.LIGHT_BLUE : PlasticLookAndFeel.getControlDarkShadow());
            g.setColor(color);
            PlasticUtils.drawRect(g, x, y, w + 1, h - 1);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return INSETS;
        }
    }

    private static final class ModernComboBoxArrowButtonBorder
    extends AbstractBorder
    implements UIResource {
        protected static final Insets INSETS = new Insets(1, 1, 1, 1);

        private ModernComboBoxArrowButtonBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            boolean paintFocus;
            PlasticComboBoxButton button = (PlasticComboBoxButton)c;
            ButtonModel model = button.getModel();
            boolean isDisabled = !model.isEnabled();
            boolean isPressed = model.isPressed() && model.isArmed();
            boolean isRollover = model.isRollover();
            boolean bl = paintFocus = ModernComboBoxArrowButtonBorder.isComboFocused(button) && PlasticModernBorders.isTextEditorBorderPaintingFocus();
            Color color = isDisabled ? MetalLookAndFeel.getControlShadow() : (isPressed ? PlasticModernUtils.DARK_BLUE : (isRollover || paintFocus ? PlasticModernUtils.LIGHT_BLUE : PlasticLookAndFeel.getControlDarkShadow()));
            g.setColor(color);
            PlasticUtils.drawRect(g, x, y, w - 1, h - 1);
        }

        private static boolean isComboFocused(PlasticComboBoxButton<?> button) {
            Container parent = button.getParent();
            if (parent == null) {
                return false;
            }
            JComboBox combo = (JComboBox)parent;
            ComboBoxEditor editor = combo.getEditor();
            if (editor == null || editor.getEditorComponent() == null) {
                return false;
            }
            return editor.getEditorComponent().isFocusOwner();
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return INSETS;
        }
    }

    private static class ModernButtonBorder
    extends AbstractBorder
    implements UIResource {
        protected final Insets insets;

        protected ModernButtonBorder(Insets insets) {
            this.insets = insets;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            AbstractButton button = (AbstractButton)c;
            ButtonModel model = button.getModel();
            boolean isDisabled = !model.isEnabled();
            boolean isPressed = model.isSelected() || model.isPressed() && model.isArmed();
            boolean isDefault = button instanceof JButton && ((JButton)button).isDefaultButton();
            boolean isRollover = model.isRollover();
            if (isDisabled) {
                PlasticModernUtils.drawDisabledButtonBorder(g, x, y, w, h);
            } else if (isPressed) {
                PlasticModernUtils.drawPressedButtonBorder(g, x, y, w, h);
            } else if (isDefault) {
                PlasticModernUtils.drawDefaultButtonBorder(g, x, y, w, h);
            } else if (isRollover) {
                PlasticModernUtils.drawRolloverButtonBorder(g, x, y, w, h);
            } else {
                PlasticModernUtils.drawPlainButtonBorder(g, x, y, w, h);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.insets;
        }

        @Override
        public Insets getBorderInsets(Component c, Insets newInsets) {
            newInsets.top = this.insets.top;
            newInsets.left = this.insets.left;
            newInsets.bottom = this.insets.bottom;
            newInsets.right = this.insets.right;
            return newInsets;
        }
    }
}

