/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.common.base.SystemUtils;
import com.jgoodies.looks.FontPolicies;
import com.jgoodies.looks.FontPolicy;
import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.MicroLayout;
import com.jgoodies.looks.MicroLayoutPolicies;
import com.jgoodies.looks.MicroLayoutPolicy;
import com.jgoodies.looks.common.ComboBoxEditorTextField;
import com.jgoodies.looks.common.MinimumSizedIcon;
import com.jgoodies.looks.common.RGBGrayFilter;
import com.jgoodies.looks.common.ShadowPopupFactory;
import com.jgoodies.looks.plastic.PlasticBorders;
import com.jgoodies.looks.plastic.PlasticIconFactory;
import com.jgoodies.looks.plastic.PlasticModernBorders;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.theme.SkyBluer;
import java.awt.Color;
import java.awt.Container;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;

public class PlasticLookAndFeel
extends MetalLookAndFeel {
    public static final String BORDER_STYLE_KEY = "Plastic.borderStyle";
    public static final String IS_3D_KEY = "Plastic.is3D";
    public static final String DEFAULT_THEME_KEY = "Plastic.defaultTheme";
    private static List<PlasticTheme> installedThemes;
    static PropertyChangeListener focusOwnerTracker;
    private static final String THEME_CLASSNAME_PREFIX = "com.jgoodies.looks.plastic.theme.";

    public PlasticLookAndFeel() {
        PlasticLookAndFeel.getPlasticTheme();
    }

    @Override
    public String getID() {
        return "Plastic";
    }

    @Override
    public String getName() {
        return "JGoodies Plastic";
    }

    @Override
    public String getDescription() {
        return "The JGoodies Plastic Look and Feel";
    }

    public static FontPolicy getFontPolicy() {
        FontPolicy policy = (FontPolicy)UIManager.get("Plastic.fontPolicy");
        if (policy != null) {
            return policy;
        }
        FontPolicy defaultPolicy = FontPolicies.getDefaultPlasticPolicy();
        return FontPolicies.customSettingsPolicy(defaultPolicy);
    }

    public static void setFontPolicy(FontPolicy fontPolicy) {
        UIManager.put("Plastic.fontPolicy", fontPolicy);
    }

    public static MicroLayoutPolicy getMicroLayoutPolicy() {
        MicroLayoutPolicy policy = (MicroLayoutPolicy)UIManager.get("Plastic.MicroLayoutPolicy");
        return policy != null ? policy : MicroLayoutPolicies.getDefaultPlasticPolicy();
    }

    public static void setMicroLayoutPolicy(MicroLayoutPolicy microLayoutPolicy) {
        UIManager.put("Plastic.MicroLayoutPolicy", microLayoutPolicy);
    }

    protected boolean is3DEnabled() {
        return false;
    }

    @Override
    public void initialize() {
        super.initialize();
        ShadowPopupFactory.install();
        focusOwnerTracker = new FocusOwnerTracker();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("permanentFocusOwner", focusOwnerTracker);
    }

    @Override
    public void uninitialize() {
        super.uninitialize();
        ShadowPopupFactory.uninstall();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", focusOwnerTracker);
        focusOwnerTracker = null;
    }

    @Override
    public Icon getDisabledIcon(JComponent component, Icon icon) {
        Icon disabledIcon = RGBGrayFilter.getDisabledIcon(component, icon);
        return disabledIcon != null ? new IconUIResource(disabledIcon) : null;
    }

    @Override
    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        String plasticPrefix = "com.jgoodies.looks.plastic.Plastic";
        String commonPrefix = "com.jgoodies.looks.common.ExtBasic";
        Object[] uiDefaults = new Object[]{"ButtonUI", "com.jgoodies.looks.plastic.PlasticButtonUI", "ToggleButtonUI", "com.jgoodies.looks.plastic.PlasticToggleButtonUI", "CheckBoxUI", "com.jgoodies.looks.plastic.PlasticCheckBoxUI", "RadioButtonUI", "com.jgoodies.looks.plastic.PlasticRadioButtonUI", "ComboBoxUI", "com.jgoodies.looks.plastic.PlasticComboBoxUI", "ScrollBarUI", "com.jgoodies.looks.plastic.PlasticScrollBarUI", "SpinnerUI", "com.jgoodies.looks.plastic.PlasticSpinnerUI", "MenuBarUI", "com.jgoodies.looks.plastic.PlasticMenuBarUI", "ToolBarUI", "com.jgoodies.looks.plastic.PlasticToolBarUI", "MenuUI", "com.jgoodies.looks.plastic.PlasticMenuUI", "MenuItemUI", "com.jgoodies.looks.common.ExtBasicMenuItemUI", "CheckBoxMenuItemUI", "com.jgoodies.looks.common.ExtBasicCheckBoxMenuItemUI", "RadioButtonMenuItemUI", "com.jgoodies.looks.common.ExtBasicRadioButtonMenuItemUI", "PopupMenuUI", "com.jgoodies.looks.plastic.PlasticPopupMenuUI", "PopupMenuSeparatorUI", "com.jgoodies.looks.common.ExtBasicPopupMenuSeparatorUI", "OptionPaneUI", "com.jgoodies.looks.plastic.PlasticOptionPaneUI", "ScrollPaneUI", "com.jgoodies.looks.plastic.PlasticScrollPaneUI", "SplitPaneUI", "com.jgoodies.looks.plastic.PlasticSplitPaneUI", "PasswordFieldUI", "com.jgoodies.looks.plastic.PlasticPasswordFieldUI", "TextAreaUI", "com.jgoodies.looks.plastic.PlasticTextAreaUI", "TreeUI", "com.jgoodies.looks.plastic.PlasticTreeUI", "InternalFrameUI", "com.jgoodies.looks.plastic.PlasticInternalFrameUI", "SeparatorUI", "com.jgoodies.looks.plastic.PlasticSeparatorUI", "ToolBarSeparatorUI", "com.jgoodies.looks.plastic.PlasticToolBarSeparatorUI", "FileChooserUI", "com.jgoodies.looks.plastic.PlasticFileChooserUI", "TabbedPaneUI", "com.jgoodies.looks.plastic.PlasticTabbedPaneUI", "TextFieldUI", "com.jgoodies.looks.plastic.PlasticTextFieldUI", "FormattedTextFieldUI", "com.jgoodies.looks.plastic.PlasticFormattedTextFieldUI"};
        table.putDefaults(uiDefaults);
    }

    @Override
    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        MicroLayout microLayout = PlasticLookAndFeel.getMicroLayoutPolicy().getMicroLayout(this.getName(), table);
        Insets buttonBorderInsets = microLayout.getButtonBorderInsets();
        BasicBorders.MarginBorder marginBorder = new BasicBorders.MarginBorder();
        Border buttonBorder = PlasticBorders.getButtonBorder(buttonBorderInsets);
        Border comboBoxButtonBorder = PlasticBorders.getComboBoxArrowButtonBorder();
        Border comboBoxEditorBorder = PlasticBorders.getComboBoxEditorBorder();
        Border menuItemBorder = PlasticBorders.getMenuItemBorder();
        Border textFieldBorder = PlasticBorders.getTextFieldBorder();
        Border toggleButtonBorder = PlasticBorders.getToggleButtonBorder(buttonBorderInsets);
        Border scrollPaneBorder = PlasticBorders.getScrollPaneBorder();
        BorderUIResource tableHeaderBorder = new BorderUIResource((Border)table.get("TableHeader.cellBorder"));
        BasicBorders.MarginBorder menuBarEmptyBorder = marginBorder;
        Border menuBarSeparatorBorder = PlasticBorders.getSeparatorBorder();
        Border menuBarEtchedBorder = PlasticBorders.getEtchedBorder();
        Border menuBarHeaderBorder = PlasticBorders.getMenuBarHeaderBorder();
        BasicBorders.MarginBorder toolBarEmptyBorder = marginBorder;
        Border toolBarSeparatorBorder = PlasticBorders.getSeparatorBorder();
        Border toolBarEtchedBorder = PlasticBorders.getEtchedBorder();
        Border toolBarHeaderBorder = PlasticBorders.getToolBarHeaderBorder();
        BorderUIResource internalFrameBorder = PlasticLookAndFeel.getInternalFrameBorder();
        BorderUIResource paletteBorder = PlasticLookAndFeel.getPaletteBorder();
        Color controlColor = table.getColor("control");
        ColorUIResource focusColor = PlasticLookAndFeel.getFocusColor();
        Icon checkBoxIcon = PlasticIconFactory.getCheckBoxIcon();
        InsetsUIResource checkBoxMargin = microLayout.getCheckBoxMargin();
        InsetsUIResource buttonMargin = microLayout.getButtonMargin();
        InsetsUIResource textInsets = microLayout.getTextInsets();
        InsetsUIResource wrappedTextInsets = microLayout.getWrappedTextInsets();
        InsetsUIResource comboEditorInsets = microLayout.getComboBoxEditorInsets();
        Insets comboEditorBorderInsets = comboBoxEditorBorder.getBorderInsets(null);
        int comboBorderSize = comboEditorBorderInsets.left;
        int comboPopupBorderSize = microLayout.getComboPopupBorderSize();
        int comboRendererGap = comboEditorInsets.left + comboBorderSize - comboPopupBorderSize;
        EmptyBorder comboRendererBorder = new EmptyBorder(1, comboRendererGap, 1, comboRendererGap);
        Insets comboTableEditorInsets = new Insets(0, 0, 0, 0);
        Insets focusInsets = new Insets(3, 3, 4, 4);
        InsetsUIResource menuItemMargin = microLayout.getMenuItemMargin();
        InsetsUIResource menuMargin = microLayout.getMenuMargin();
        MinimumSizedIcon menuItemCheckIcon = new MinimumSizedIcon();
        Icon checkBoxMenuItemIcon = PlasticIconFactory.getCheckBoxMenuItemIcon();
        Icon radioButtonMenuItemIcon = PlasticIconFactory.getRadioButtonMenuItemIcon();
        Color menuItemForeground = table.getColor("MenuItem.foreground");
        Color inactiveTextBackground = table.getColor("TextField.inactiveBackground");
        int treeFontSize = table.getFont("Tree.font").getSize();
        Integer rowHeight = new Integer(treeFontSize + 6);
        Icon treeExpandedIcon = PlasticIconFactory.getExpandedTreeIcon();
        Icon treeCollapsedIcon = PlasticIconFactory.getCollapsedTreeIcon();
        ColorUIResource gray = new ColorUIResource(Color.GRAY);
        Boolean is3D = this.is3DEnabled();
        Character passwordEchoChar = new Character(SystemUtils.IS_OS_WINDOWS ? (char)'\u25cf' : '\u2022');
        String iconPrefix = "icons/" + (SystemUtils.IS_LOW_RESOLUTION ? "32x32/" : "48x48/");
        Object errorIcon = PlasticLookAndFeel.makeIcon(PlasticLookAndFeel.class, iconPrefix + "dialog-error.png");
        Object informationIcon = PlasticLookAndFeel.makeIcon(PlasticLookAndFeel.class, iconPrefix + "dialog-information.png");
        Object helpIcon = PlasticLookAndFeel.makeIcon(PlasticLookAndFeel.class, iconPrefix + "dialog-help.png");
        Object warningIcon = PlasticLookAndFeel.makeIcon(PlasticLookAndFeel.class, iconPrefix + "dialog-warning.png");
        Object[] defaults = new Object[]{"Button.border", buttonBorder, "Button.margin", buttonMargin, "Button.defaultButtonFollowsFocus", Boolean.TRUE, "Button.borderPaintsFocus", Boolean.FALSE, "Button.focus", focusColor, "Button.focusInsets", focusInsets, "CheckBox.margin", checkBoxMargin, "CheckBox.focus", focusColor, "CheckBox.icon", checkBoxIcon, "CheckBoxMenuItem.border", menuItemBorder, "CheckBoxMenuItem.margin", menuItemMargin, "CheckBoxMenuItem.checkIcon", checkBoxMenuItemIcon, "CheckBoxMenuItem.background", PlasticLookAndFeel.getMenuItemBackground(), "CheckBoxMenuItem.selectionForeground", PlasticLookAndFeel.getMenuItemSelectedForeground(), "CheckBoxMenuItem.selectionBackground", PlasticLookAndFeel.getMenuItemSelectedBackground(), "CheckBoxMenuItem.acceleratorForeground", menuItemForeground, "CheckBoxMenuItem.acceleratorSelectionForeground", PlasticLookAndFeel.getMenuItemSelectedForeground(), "CheckBoxMenuItem.acceleratorSelectionBackground", PlasticLookAndFeel.getMenuItemSelectedBackground(), "ComboBox.selectionForeground", PlasticLookAndFeel.getMenuSelectedForeground(), "ComboBox.selectionBackground", PlasticLookAndFeel.getMenuSelectedBackground(), "ComboBox.arrowIcon", PlasticIconFactory.getComboBoxButtonIcon(), "ComboBox.arrowButtonBorder", comboBoxButtonBorder, "ComboBox.editorBorder", comboBoxEditorBorder, "ComboBox.editorColumns", new Integer(5), "ComboBox.editorBorderInsets", comboEditorBorderInsets, "ComboBox.editorInsets", textInsets, "ComboBox.tableEditorInsets", comboTableEditorInsets, "ComboBox.rendererBorder", comboRendererBorder, "ComboBox.borderPaintsFocus", Boolean.FALSE, "ComboBox.focus", focusColor, "ComboBox.focusInsets", focusInsets, "EditorPane.margin", wrappedTextInsets, "InternalFrame.border", internalFrameBorder, "InternalFrame.paletteBorder", paletteBorder, "List.font", PlasticLookAndFeel.getControlTextFont(), "Menu.border", PlasticBorders.getMenuBorder(), "Menu.margin", menuMargin, "Menu.arrowIcon", PlasticIconFactory.getMenuArrowIcon(), "MenuBar.emptyBorder", menuBarEmptyBorder, "MenuBar.separatorBorder", menuBarSeparatorBorder, "MenuBar.etchedBorder", menuBarEtchedBorder, "MenuBar.headerBorder", menuBarHeaderBorder, "MenuItem.border", menuItemBorder, "MenuItem.checkIcon", menuItemCheckIcon, "MenuItem.margin", menuItemMargin, "MenuItem.background", PlasticLookAndFeel.getMenuItemBackground(), "MenuItem.selectionForeground", PlasticLookAndFeel.getMenuItemSelectedForeground(), "MenuItem.selectionBackground", PlasticLookAndFeel.getMenuItemSelectedBackground(), "MenuItem.acceleratorForeground", menuItemForeground, "MenuItem.acceleratorSelectionForeground", PlasticLookAndFeel.getMenuItemSelectedForeground(), "MenuItem.acceleratorSelectionBackground", PlasticLookAndFeel.getMenuItemSelectedBackground(), "OptionPane.errorIcon", errorIcon, "OptionPane.informationIcon", informationIcon, "OptionPane.questionIcon", helpIcon, "OptionPane.warningIcon", warningIcon, "FileView.computerIcon", PlasticLookAndFeel.makeIcon(PlasticLookAndFeel.class, "icons/Computer.gif"), "FileView.directoryIcon", PlasticLookAndFeel.makeIcon(PlasticLookAndFeel.class, "icons/TreeClosed.gif"), "FileView.fileIcon", PlasticLookAndFeel.makeIcon(PlasticLookAndFeel.class, "icons/File.gif"), "FileView.floppyDriveIcon", PlasticLookAndFeel.makeIcon(PlasticLookAndFeel.class, "icons/FloppyDrive.gif"), "FileView.hardDriveIcon", PlasticLookAndFeel.makeIcon(PlasticLookAndFeel.class, "icons/HardDrive.gif"), "FileChooser.homeFolderIcon", PlasticLookAndFeel.makeIcon(PlasticLookAndFeel.class, "icons/HomeFolder.gif"), "FileChooser.newFolderIcon", PlasticLookAndFeel.makeIcon(PlasticLookAndFeel.class, "icons/NewFolder.gif"), "FileChooser.upFolderIcon", PlasticLookAndFeel.makeIcon(PlasticLookAndFeel.class, "icons/UpFolder.gif"), "FileChooser.useSystemIcons", Boolean.TRUE, "TabbedPane.focus", focusColor, "Tree.closedIcon", PlasticLookAndFeel.makeIcon(PlasticLookAndFeel.class, "icons/TreeClosed.gif"), "Tree.openIcon", PlasticLookAndFeel.makeIcon(PlasticLookAndFeel.class, "icons/TreeOpen.gif"), "Tree.leafIcon", PlasticLookAndFeel.makeIcon(PlasticLookAndFeel.class, "icons/TreeLeaf.gif"), "FormattedTextField.border", textFieldBorder, "FormattedTextField.margin", textInsets, "PasswordField.border", textFieldBorder, "PasswordField.margin", textInsets, "PasswordField.echoChar", passwordEchoChar, "PopupMenu.border", PlasticBorders.getPopupMenuBorder(), "PopupMenu.noMarginBorder", PlasticBorders.getNoMarginPopupMenuBorder(), "PopupMenuSeparator.margin", new InsetsUIResource(3, 4, 3, 4), "RadioButton.margin", checkBoxMargin, "RadioButton.focus", focusColor, "RadioButtonMenuItem.border", menuItemBorder, "RadioButtonMenuItem.checkIcon", radioButtonMenuItemIcon, "RadioButtonMenuItem.margin", menuItemMargin, "RadioButtonMenuItem.background", PlasticLookAndFeel.getMenuItemBackground(), "RadioButtonMenuItem.selectionForeground", PlasticLookAndFeel.getMenuItemSelectedForeground(), "RadioButtonMenuItem.selectionBackground", PlasticLookAndFeel.getMenuItemSelectedBackground(), "RadioButtonMenuItem.acceleratorForeground", menuItemForeground, "RadioButtonMenuItem.acceleratorSelectionForeground", PlasticLookAndFeel.getMenuItemSelectedForeground(), "RadioButtonMenuItem.acceleratorSelectionBackground", PlasticLookAndFeel.getMenuItemSelectedBackground(), "Separator.foreground", PlasticLookAndFeel.getControlDarkShadow(), "ScrollPane.border", scrollPaneBorder, "ScrollPane.etchedBorder", scrollPaneBorder, "SimpleInternalFrame.activeTitleForeground", PlasticLookAndFeel.getSimpleInternalFrameForeground(), "SimpleInternalFrame.activeTitleBackground", PlasticLookAndFeel.getSimpleInternalFrameBackground(), "Slider.focus", focusColor, "Spinner.border", PlasticBorders.getFlush3DBorder(), "Spinner.defaultEditorInsets", textInsets, "SplitPane.dividerSize", new Integer(7), "TabbedPane.focus", PlasticLookAndFeel.getFocusColor(), "TabbedPane.tabInsets", new InsetsUIResource(1, 4, 1, 4), "TabbedPane.highlight", table.get("controlShadow"), "TabbedPane.shadow", table.get("controlShadow"), "TabbedPane.darkShadow", table.getColor("controlLtHighlight"), "TabbedPane.background", table.getColor("Button.background"), "Table.foreground", table.get("textText"), "Table.gridColor", controlColor, "Table.scrollPaneBorder", scrollPaneBorder, "TableHeader.cellBorder", tableHeaderBorder, "TextArea.inactiveBackground", inactiveTextBackground, "TextArea.margin", wrappedTextInsets, "TextField.border", textFieldBorder, "TextField.margin", textInsets, "TitledBorder.font", PlasticLookAndFeel.getTitleTextFont(), "TitledBorder.titleColor", PlasticLookAndFeel.getTitleTextColor(), "TextEditor.borderPaintsFocus", Boolean.FALSE, "ToggleButton.border", toggleButtonBorder, "ToggleButton.margin", buttonMargin, "ToggleButton.borderPaintsFocus", Boolean.FALSE, "ToggleButton.focus", focusColor, "ToggleButton.focusInsets", focusInsets, "ToolBar.emptyBorder", toolBarEmptyBorder, "ToolBar.separatorBorder", toolBarSeparatorBorder, "ToolBar.etchedBorder", toolBarEtchedBorder, "ToolBar.headerBorder", toolBarHeaderBorder, "ToolTip.hideAccelerator", Boolean.TRUE, "Tree.expandedIcon", treeExpandedIcon, "Tree.collapsedIcon", treeCollapsedIcon, "Tree.line", gray, "Tree.hash", gray, "Tree.rowHeight", rowHeight, "Button.is3DEnabled", is3D, "ComboBox.is3DEnabled", is3D, "MenuBar.is3DEnabled", is3D, "ToolBar.is3DEnabled", is3D, "ScrollBar.is3DEnabled", is3D, "ToggleButton.is3DEnabled", is3D, "CheckBox.border", marginBorder, "RadioButton.border", marginBorder, "ProgressBar.selectionForeground", PlasticLookAndFeel.getSystemTextColor(), "ProgressBar.selectionBackground", PlasticLookAndFeel.getSystemTextColor()};
        table.putDefaults(defaults);
        String soundPathPrefix = "/javax/swing/plaf/metal/";
        Object[] auditoryCues = (Object[])table.get("AuditoryCues.allAuditoryCues");
        if (auditoryCues != null) {
            Object[] audioDefaults = new String[auditoryCues.length * 2];
            for (int i = 0; i < auditoryCues.length; ++i) {
                Object auditoryCue;
                audioDefaults[2 * i] = auditoryCue = auditoryCues[i];
                audioDefaults[2 * i + 1] = soundPathPrefix + table.getString(auditoryCue);
            }
            table.putDefaults(audioDefaults);
        }
    }

    @Override
    protected void initSystemColorDefaults(UIDefaults table) {
        super.initSystemColorDefaults(table);
        table.put("unifiedControlShadow", table.getColor("controlDkShadow"));
        table.put("primaryControlHighlight", PlasticLookAndFeel.getPrimaryControlHighlight());
    }

    public static PlasticTheme createMyDefaultTheme() {
        PlasticTheme result;
        String defaultName = SystemUtils.IS_LAF_WINDOWS_XP_ENABLED ? PlasticLookAndFeel.getDefaultWindowsTheme() : "LightGray";
        String userName = LookUtils.getSystemProperty(DEFAULT_THEME_KEY, "");
        boolean overridden = userName.length() > 0;
        String themeName = overridden ? userName : defaultName;
        PlasticTheme theme = PlasticLookAndFeel.createTheme(themeName);
        PlasticTheme plasticTheme = result = theme != null ? theme : new SkyBluer();
        if (overridden) {
            String className = result.getClass().getName().substring(THEME_CLASSNAME_PREFIX.length());
            if (className.equals(userName)) {
                LookUtils.log("I have successfully installed the '" + result.getName() + "' theme.");
            } else {
                LookUtils.log("I could not install the Plastic theme '" + userName + "'.");
                LookUtils.log("I have installed the '" + result.getName() + "' theme, instead.");
            }
        }
        return result;
    }

    private static String getDefaultWindowsTheme() {
        String defaultName = "LightGray";
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        String xpstyleDll = (String)toolkit.getDesktopProperty("win.xpstyle.dllName");
        if (xpstyleDll == null) {
            return defaultName;
        }
        if (xpstyleDll.endsWith("luna.msstyles")) {
            return "ExperienceRoyale";
        }
        if (xpstyleDll.endsWith("Royale.msstyles")) {
            return "ExperienceBlue";
        }
        return defaultName;
    }

    public static List<PlasticTheme> getInstalledThemes() {
        if (null == installedThemes) {
            PlasticLookAndFeel.installDefaultThemes();
        }
        Collections.sort(installedThemes, new Comparator<PlasticTheme>(){

            @Override
            public int compare(PlasticTheme o1, PlasticTheme o2) {
                PlasticTheme theme1 = o1;
                PlasticTheme theme2 = o2;
                return ((MetalTheme)theme1).getName().compareTo(((MetalTheme)theme2).getName());
            }
        });
        return installedThemes;
    }

    protected static void installDefaultThemes() {
        installedThemes = new ArrayList<PlasticTheme>();
        String[] themeNames = new String[]{"BrownSugar", "DarkStar", "DesertBlue", "DesertBluer", "ExperienceBlue", "ExperienceRoyale", "LightGray", "SkyBlue", "SkyBluer"};
        for (int i = themeNames.length - 1; i >= 0; --i) {
            PlasticLookAndFeel.installTheme(PlasticLookAndFeel.createTheme(themeNames[i]));
        }
    }

    protected static PlasticTheme createTheme(String themeName) {
        String className = THEME_CLASSNAME_PREFIX + themeName;
        try {
            Class<?> cl = Class.forName(className);
            return (PlasticTheme)cl.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            LookUtils.log("Can't create theme " + className);
            return null;
        }
    }

    public static void installTheme(PlasticTheme theme) {
        if (null == installedThemes) {
            PlasticLookAndFeel.installDefaultThemes();
        }
        installedThemes.add(theme);
    }

    public static PlasticTheme getPlasticTheme() {
        MetalTheme theme = PlasticLookAndFeel.getCurrentTheme();
        if (theme instanceof PlasticTheme) {
            return (PlasticTheme)theme;
        }
        PlasticTheme initialTheme = PlasticLookAndFeel.createMyDefaultTheme();
        PlasticLookAndFeel.setPlasticTheme(initialTheme);
        return initialTheme;
    }

    public static void setPlasticTheme(PlasticTheme theme) {
        PlasticLookAndFeel.setCurrentTheme(theme);
    }

    public static BorderUIResource getInternalFrameBorder() {
        return new BorderUIResource(PlasticBorders.getInternalFrameBorder());
    }

    public static BorderUIResource getPaletteBorder() {
        return new BorderUIResource(PlasticBorders.getPaletteBorder());
    }

    public static ColorUIResource getPrimaryControlDarkShadow() {
        return PlasticLookAndFeel.getPlasticTheme().getPrimaryControlDarkShadow();
    }

    public static ColorUIResource getPrimaryControlHighlight() {
        return PlasticLookAndFeel.getPlasticTheme().getPrimaryControlHighlight();
    }

    public static ColorUIResource getPrimaryControlInfo() {
        return PlasticLookAndFeel.getPlasticTheme().getPrimaryControlInfo();
    }

    public static ColorUIResource getPrimaryControlShadow() {
        return PlasticLookAndFeel.getPlasticTheme().getPrimaryControlShadow();
    }

    public static ColorUIResource getPrimaryControl() {
        return PlasticLookAndFeel.getPlasticTheme().getPrimaryControl();
    }

    public static ColorUIResource getControlHighlight() {
        return PlasticLookAndFeel.getPlasticTheme().getControlHighlight();
    }

    public static ColorUIResource getControlDarkShadow() {
        return PlasticLookAndFeel.getPlasticTheme().getControlDarkShadow();
    }

    public static ColorUIResource getControl() {
        return PlasticLookAndFeel.getPlasticTheme().getControl();
    }

    public static ColorUIResource getFocusColor() {
        return PlasticLookAndFeel.getPlasticTheme().getFocusColor();
    }

    public static ColorUIResource getMenuItemBackground() {
        return PlasticLookAndFeel.getPlasticTheme().getMenuItemBackground();
    }

    public static ColorUIResource getMenuItemSelectedBackground() {
        return PlasticLookAndFeel.getPlasticTheme().getMenuItemSelectedBackground();
    }

    public static ColorUIResource getMenuItemSelectedForeground() {
        return PlasticLookAndFeel.getPlasticTheme().getMenuItemSelectedForeground();
    }

    public static ColorUIResource getWindowTitleBackground() {
        return PlasticLookAndFeel.getPlasticTheme().getWindowTitleBackground();
    }

    public static ColorUIResource getWindowTitleForeground() {
        return PlasticLookAndFeel.getPlasticTheme().getWindowTitleForeground();
    }

    public static ColorUIResource getWindowTitleInactiveBackground() {
        return PlasticLookAndFeel.getPlasticTheme().getWindowTitleInactiveBackground();
    }

    public static ColorUIResource getWindowTitleInactiveForeground() {
        return PlasticLookAndFeel.getPlasticTheme().getWindowTitleInactiveForeground();
    }

    public static ColorUIResource getSimpleInternalFrameForeground() {
        return PlasticLookAndFeel.getPlasticTheme().getSimpleInternalFrameForeground();
    }

    public static ColorUIResource getSimpleInternalFrameBackground() {
        return PlasticLookAndFeel.getPlasticTheme().getSimpleInternalFrameBackground();
    }

    public static ColorUIResource getTitleTextColor() {
        return PlasticLookAndFeel.getPlasticTheme().getTitleTextColor();
    }

    public static FontUIResource getTitleTextFont() {
        return PlasticLookAndFeel.getPlasticTheme().getTitleTextFont();
    }

    static final class FocusOwnerTracker
    implements PropertyChangeListener {
        FocusOwnerTracker() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!"permanentFocusOwner".equals(evt.getPropertyName())) {
                return;
            }
            FocusOwnerTracker.repaintFocusIfNecessary(evt.getOldValue());
            FocusOwnerTracker.repaintFocusIfNecessary(evt.getNewValue());
        }

        private static void repaintFocusIfNecessary(Object owner) {
            if (!(owner instanceof JComponent)) {
                return;
            }
            JComponent c = (JComponent)owner;
            Container parent = c.getParent();
            if (c instanceof ComboBoxEditorTextField) {
                if (parent != null) {
                    parent.repaint();
                }
                return;
            }
            if (parent != null && parent.getParent() instanceof JSpinner) {
                parent.getParent().repaint();
                return;
            }
            Border border = c.getBorder();
            if (!(border instanceof BorderUIResource.CompoundBorderUIResource)) {
                return;
            }
            CompoundBorder compoundBorder = (CompoundBorder)border;
            if (compoundBorder.getOutsideBorder() instanceof PlasticModernBorders.ModernTextFieldBorder) {
                c.repaint();
                return;
            }
        }
    }
}

