/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.decoration.internal;

import com.jgoodies.common.base.Strings;
import com.jgoodies.looks.decoration.internal.MyFontUtilities;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.text.AttributedString;
import javax.swing.JComponent;

public final class MySwingUtilities2 {
    private static final int CHAR_BUFFER_SIZE = 100;
    private static final Object charsBufferLock = new Object();
    private static char[] charsBuffer = new char[100];
    private static final FontRenderContext DEFAULT_FRC = new FontRenderContext(null, false, false);

    private MySwingUtilities2() {
    }

    public static int stringWidth(JComponent c, FontMetrics fm, String str) {
        if (Strings.isBlank((String)str)) {
            return 0;
        }
        return fm.stringWidth(str);
    }

    public static String clipStringIfNecessary(JComponent c, FontMetrics fm, String string, int availTextWidth) {
        if (string == null || string.equals("")) {
            return "";
        }
        int textWidth = MySwingUtilities2.stringWidth(c, fm, string);
        if (textWidth > availTextWidth) {
            return MySwingUtilities2.clipString(c, fm, string, availTextWidth);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String clipString(JComponent c, FontMetrics fm, String string, int availTextWidth) {
        String clipString = "...";
        int stringLength = string.length();
        if ((availTextWidth -= MySwingUtilities2.stringWidth(c, fm, clipString)) <= 0) {
            return clipString;
        }
        boolean needsTextLayout = false;
        Object object = charsBufferLock;
        synchronized (object) {
            if (charsBuffer == null || charsBuffer.length < stringLength) {
                charsBuffer = string.toCharArray();
            } else {
                string.getChars(0, stringLength, charsBuffer, 0);
            }
            needsTextLayout = MySwingUtilities2.isComplexLayout(charsBuffer, 0, stringLength);
            if (!needsTextLayout) {
                int width = 0;
                for (int nChars = 0; nChars < stringLength; ++nChars) {
                    if ((width += fm.charWidth(charsBuffer[nChars])) <= availTextWidth) continue;
                    string = string.substring(0, nChars);
                    break;
                }
            }
        }
        if (needsTextLayout) {
            FontRenderContext frc = MySwingUtilities2.getFontRenderContext(c, fm);
            AttributedString aString = new AttributedString(string);
            LineBreakMeasurer measurer = new LineBreakMeasurer(aString.getIterator(), frc);
            int nChars = measurer.nextOffset(availTextWidth);
            string = string.substring(0, nChars);
        }
        return string + clipString;
    }

    private static final boolean isComplexLayout(char[] text, int start, int limit) {
        return MyFontUtilities.isComplexText(text, start, limit);
    }

    private static FontRenderContext getFontRenderContext(Component c, FontMetrics fm) {
        assert (fm != null || c != null);
        return fm != null ? fm.getFontRenderContext() : MySwingUtilities2.getFontRenderContext(c);
    }

    private static FontRenderContext getFontRenderContext(Component c) {
        assert (c != null);
        if (c == null) {
            return DEFAULT_FRC;
        }
        return c.getFontMetrics(c.getFont()).getFontRenderContext();
    }
}

