/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.decoration;

import com.jgoodies.common.internal.RenderingUtils;
import com.jgoodies.looks.decoration.MetroRootPaneUI;
import com.jgoodies.looks.decoration.internal.MySwingUtilities2;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

class MetroTitlePane
extends JComponent {
    private static final Border EMPTY_BORDER = new EmptyBorder(0, 0, 0, 0);
    private static final int IMAGE_HEIGHT = 16;
    private static final int IMAGE_WIDTH = 16;
    private PropertyChangeListener propertyChangeListener;
    private JMenuBar menuBar;
    private Action closeAction;
    private Action iconifyAction;
    private Action restoreAction;
    private Action maximizeAction;
    private JButton toggleButton;
    private JButton iconifyButton;
    private JButton closeButton;
    private Color background;
    private Image systemIcon;
    private WindowListener windowListener;
    private Window window;
    private final JRootPane rootPane;
    private int state;

    public MetroTitlePane(JRootPane root, MetroRootPaneUI ui) {
        this.rootPane = root;
        this.state = -1;
        this.installSubcomponents();
        this.installDefaults();
        this.setLayout(this.createLayout());
    }

    private void installListeners() {
        if (this.window != null) {
            this.windowListener = this.createWindowListener();
            this.window.addWindowListener(this.windowListener);
            this.propertyChangeListener = this.createWindowPropertyChangeListener();
            this.window.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    private void uninstallListeners() {
        if (this.window != null) {
            this.window.removeWindowListener(this.windowListener);
            this.window.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    private WindowListener createWindowListener() {
        return new WindowHandler();
    }

    private PropertyChangeListener createWindowPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    @Override
    public JRootPane getRootPane() {
        return this.rootPane;
    }

    private int getWindowDecorationStyle() {
        return this.getRootPane().getWindowDecorationStyle();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.uninstallListeners();
        this.window = SwingUtilities.getWindowAncestor(this);
        if (this.window != null) {
            if (this.window instanceof Frame) {
                this.setState(((Frame)this.window).getExtendedState());
            } else {
                this.setState(0);
            }
            this.setActive(this.window.isActive());
            this.installListeners();
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.uninstallListeners();
        this.window = null;
    }

    private void installSubcomponents() {
        int decorationStyle = this.getWindowDecorationStyle();
        if (decorationStyle == 1) {
            this.createActions();
            this.createButtons();
            this.add(this.iconifyButton);
            this.add(this.toggleButton);
            this.add(this.closeButton);
        } else if (decorationStyle == 2 || decorationStyle == 3 || decorationStyle == 4 || decorationStyle == 5 || decorationStyle == 6 || decorationStyle == 7 || decorationStyle == 8) {
            this.createActions();
            this.createButtons();
            this.add(this.closeButton);
        }
    }

    private void installDefaults() {
        this.setFont(new Font("Segoe UI", 0, 12));
    }

    protected JMenuBar createMenuBar() {
        this.menuBar = new SystemMenuBar();
        this.menuBar.setFocusable(false);
        this.menuBar.setBorderPainted(true);
        this.menuBar.add(this.createMenu());
        return this.menuBar;
    }

    private void close() {
        Window window = this.getWindow();
        if (window != null) {
            window.dispatchEvent(new WindowEvent(window, 201));
        }
    }

    private void iconify() {
        Frame frame = this.getFrame();
        if (frame != null) {
            frame.setExtendedState(this.state | 1);
        }
    }

    private void maximize() {
        Frame frame = this.getFrame();
        if (frame != null) {
            frame.setExtendedState(this.state | 6);
        }
    }

    private void restore() {
        Frame frame = this.getFrame();
        if (frame == null) {
            return;
        }
        if ((this.state & 1) != 0) {
            frame.setExtendedState(this.state & 0xFFFFFFFE);
        } else {
            frame.setExtendedState(this.state & 0xFFFFFFF9);
        }
    }

    private void createActions() {
        this.closeAction = new CloseAction();
        if (this.getWindowDecorationStyle() == 1) {
            this.iconifyAction = new IconifyAction();
            this.restoreAction = new RestoreAction();
            this.maximizeAction = new MaximizeAction();
        }
    }

    private JMenu createMenu() {
        JMenu menu = new JMenu("");
        if (this.getWindowDecorationStyle() == 1) {
            this.addMenuItems(menu);
        }
        return menu;
    }

    private void addMenuItems(JMenu menu) {
        JMenuItem mi = menu.add(this.restoreAction);
        int mnemonic = -1;
        if (mnemonic != -1) {
            mi.setMnemonic(mnemonic);
        }
        mi = menu.add(this.iconifyAction);
        if (mnemonic != -1) {
            mi.setMnemonic(mnemonic);
        }
        if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
            mi = menu.add(this.maximizeAction);
            if (mnemonic != -1) {
                mi.setMnemonic(mnemonic);
            }
        }
        menu.add(new JSeparator());
        mi = menu.add(this.closeAction);
        if (mnemonic != -1) {
            mi.setMnemonic(mnemonic);
        }
    }

    private static JButton createTitleButton() {
        JButton button = new JButton();
        button.setFocusPainted(false);
        button.setFocusable(false);
        button.setOpaque(true);
        button.setContentAreaFilled(false);
        button.putClientProperty("ControlList.exclude", Boolean.TRUE);
        return button;
    }

    private void createButtons() {
        this.closeButton = MetroTitlePane.createTitleButton();
        this.closeButton.setAction(this.closeAction);
        this.closeButton.setText(null);
        this.closeButton.putClientProperty("paintActive", Boolean.TRUE);
        this.closeButton.setBorder(EMPTY_BORDER);
        this.closeButton.setIcon(MetroTitlePane.getIcon("close.inactive"));
        this.closeButton.setRolloverIcon(MetroTitlePane.getIcon("close.rollover"));
        this.closeButton.setPressedIcon(MetroTitlePane.getIcon("close.pressed"));
        if (this.getWindowDecorationStyle() == 1) {
            this.iconifyButton = MetroTitlePane.createTitleButton();
            this.iconifyButton.setAction(this.iconifyAction);
            this.iconifyButton.setText(null);
            this.iconifyButton.putClientProperty("paintActive", Boolean.TRUE);
            this.iconifyButton.setBorder(EMPTY_BORDER);
            this.iconifyButton.setIcon(MetroTitlePane.getIcon("iconify.inactive"));
            this.iconifyButton.setRolloverIcon(MetroTitlePane.getIcon("iconify.rollover"));
            this.iconifyButton.setPressedIcon(MetroTitlePane.getIcon("iconify.pressed"));
            this.toggleButton = MetroTitlePane.createTitleButton();
            this.toggleButton.setAction(this.restoreAction);
            this.toggleButton.putClientProperty("paintActive", Boolean.TRUE);
            this.toggleButton.setBorder(EMPTY_BORDER);
        }
    }

    private LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    private void setActive(boolean active) {
        String suffix;
        Boolean activeB = active;
        this.closeButton.putClientProperty("paintActive", activeB);
        if (this.getWindowDecorationStyle() == 1) {
            this.iconifyButton.putClientProperty("paintActive", activeB);
            this.toggleButton.putClientProperty("paintActive", activeB);
        }
        this.background = MetroTitlePane.getColor(active ? "active.background" : "inactive.background");
        String string = suffix = active ? ".active" : ".inactive";
        if (this.getWindowDecorationStyle() == 1) {
            this.iconifyButton.setIcon(MetroTitlePane.getIcon("iconify" + suffix));
            boolean maximized = (this.state & 6) != 0;
            String togglePrefix = maximized ? "restore" : "maximize";
            this.toggleButton.setIcon(MetroTitlePane.getIcon(togglePrefix + suffix));
            this.toggleButton.setRolloverIcon(MetroTitlePane.getIcon(togglePrefix + ".rollover"));
            this.toggleButton.setPressedIcon(MetroTitlePane.getIcon(togglePrefix + ".pressed"));
        }
        this.closeButton.setIcon(MetroTitlePane.getIcon("close" + suffix));
        this.getRootPane().repaint();
    }

    private void setState(int state) {
        this.setState(state, false);
    }

    private void setState(int state, boolean updateRegardless) {
        Window w = this.getWindow();
        if (w != null && this.getWindowDecorationStyle() == 1) {
            boolean active;
            if (this.state == state && !updateRegardless) {
                return;
            }
            Frame frame = this.getFrame();
            boolean bl = active = frame != null && frame.isActive();
            if (frame != null) {
                JRootPane rootPane = this.getRootPane();
                if ((state & 6) != 0) {
                    MetroRootPaneUI.installMaximizedBorder(rootPane);
                } else if ((state & 6) == 0) {
                    MetroRootPaneUI.installDefaultBorder(rootPane);
                }
                if (frame.isResizable()) {
                    if ((state & 6) != 0) {
                        this.updateToggleButton(this.restoreAction, active, true);
                        this.maximizeAction.setEnabled(false);
                        this.restoreAction.setEnabled(true);
                    } else {
                        this.updateToggleButton(this.maximizeAction, active, false);
                        this.maximizeAction.setEnabled(true);
                        this.restoreAction.setEnabled(false);
                    }
                    if (this.toggleButton.getParent() == null || this.iconifyButton.getParent() == null) {
                        this.add(this.toggleButton);
                        this.add(this.iconifyButton);
                        this.revalidate();
                        this.repaint();
                    }
                    this.toggleButton.setText(null);
                } else {
                    this.maximizeAction.setEnabled(false);
                    this.restoreAction.setEnabled(false);
                    if (this.toggleButton.getParent() != null) {
                        this.remove(this.toggleButton);
                        this.revalidate();
                        this.repaint();
                    }
                }
            } else {
                this.maximizeAction.setEnabled(false);
                this.restoreAction.setEnabled(false);
                this.iconifyAction.setEnabled(false);
                this.remove(this.toggleButton);
                this.remove(this.iconifyButton);
                this.revalidate();
                this.repaint();
            }
            this.closeAction.setEnabled(true);
            this.state = state;
        }
    }

    private void updateToggleButton(Action action, boolean active, boolean maximized) {
        this.toggleButton.setAction(action);
        this.toggleButton.setText(null);
        String suffix = active ? ".active" : ".inactive";
        String togglePrefix = maximized ? "restore" : "maximize";
        this.toggleButton.setIcon(MetroTitlePane.getIcon(togglePrefix + suffix));
        this.toggleButton.setRolloverIcon(MetroTitlePane.getIcon(togglePrefix + ".rollover"));
        this.toggleButton.setPressedIcon(MetroTitlePane.getIcon(togglePrefix + ".pressed"));
    }

    private Frame getFrame() {
        Window window = this.getWindow();
        if (window instanceof Frame) {
            return (Frame)window;
        }
        return null;
    }

    private Window getWindow() {
        return this.window;
    }

    private String getTitle() {
        Window w = this.getWindow();
        if (w instanceof Frame) {
            return ((Frame)w).getTitle();
        }
        if (w instanceof Dialog) {
            return ((Dialog)w).getTitle();
        }
        return null;
    }

    private static Color getColor(String key) {
        return null;
    }

    private static Icon getIcon(String key) {
        return null;
    }

    private static String getString(String key) {
        return null;
    }

    @Override
    public void paintComponent(Graphics g) {
        String miniTitle;
        String theTitle;
        int xOffset;
        if (this.getFrame() != null) {
            this.setState(this.getFrame().getExtendedState());
        }
        JRootPane rootPane = this.getRootPane();
        Window window = this.getWindow();
        boolean leftToRight = window == null ? rootPane.getComponentOrientation().isLeftToRight() : window.getComponentOrientation().isLeftToRight();
        int width = this.getWidth();
        int height = this.getHeight();
        boolean active = window != null && window.isActive();
        Color foreground = active ? Color.BLACK : new Color(128, 128, 128);
        g.setColor(this.background);
        g.fillRect(0, 0, width, height);
        int n = xOffset = leftToRight ? 12 : width - 12;
        if (this.getWindowDecorationStyle() == 1) {
            xOffset += leftToRight ? 0 : 0;
        }
        if ((theTitle = this.getTitle()) != null) {
            FontMetrics fm = rootPane.getFontMetrics(g.getFont());
            g.setColor(foreground);
            int yOffset = (height - fm.getHeight()) / 2 + fm.getAscent();
            Rectangle rect = new Rectangle(0, 0, 0, 0);
            if (this.iconifyButton != null && this.iconifyButton.getParent() != null) {
                rect = this.iconifyButton.getBounds();
            }
            if (leftToRight) {
                if (rect.x == 0 && null != window) {
                    rect.x = window.getWidth() - window.getInsets().right - 2;
                }
                int titleW = rect.x - xOffset - 4;
                theTitle = MySwingUtilities2.clipStringIfNecessary(rootPane, fm, theTitle, titleW);
            } else {
                int titleW = xOffset - rect.x - rect.width - 4;
                theTitle = MySwingUtilities2.clipStringIfNecessary(rootPane, fm, theTitle, titleW);
                xOffset -= MySwingUtilities2.stringWidth(rootPane, fm, theTitle);
            }
            int titleLength = MySwingUtilities2.stringWidth(rootPane, fm, theTitle);
            RenderingUtils.drawString((JComponent)rootPane, (Graphics)g, (String)theTitle, (int)xOffset, (int)yOffset);
            xOffset += leftToRight ? titleLength + 5 : -5;
        }
        if ((miniTitle = (String)rootPane.getClientProperty("miniTitle")) == null) {
            return;
        }
        g.setFont(new Font("Segoe UI", 0, 10));
        FontMetrics fm = rootPane.getFontMetrics(g.getFont());
        xOffset = width - 165;
        int yOffset = 6 + fm.getAscent();
        g.setColor(new Color(199, 80, 80));
        RenderingUtils.drawString((JComponent)rootPane, (Graphics)g, (String)miniTitle, (int)xOffset, (int)yOffset);
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        @Override
        public void windowActivated(WindowEvent ev) {
            MetroTitlePane.this.setActive(true);
        }

        @Override
        public void windowDeactivated(WindowEvent ev) {
            MetroTitlePane.this.setActive(false);
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            String name = pce.getPropertyName();
            if ("resizable".equals(name) || "state".equals(name)) {
                Frame frame = MetroTitlePane.this.getFrame();
                if (frame != null) {
                    MetroTitlePane.this.setState(frame.getExtendedState(), true);
                }
                if ("resizable".equals(name)) {
                    MetroTitlePane.this.getRootPane().repaint();
                }
            } else if ("title".equals(name)) {
                MetroTitlePane.this.repaint();
            } else if ("componentOrientation" == name) {
                MetroTitlePane.this.revalidate();
                MetroTitlePane.this.repaint();
            }
        }
    }

    private class TitlePaneLayout
    implements LayoutManager {
        private TitlePaneLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            int height = this.computeHeight();
            return new Dimension(height, height);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        private int computeHeight() {
            return 31;
        }

        @Override
        public void layoutContainer(Container c) {
            int closeWidth;
            int buttonHeight;
            boolean leftToRight = MetroTitlePane.this.window == null ? MetroTitlePane.this.getRootPane().getComponentOrientation().isLeftToRight() : MetroTitlePane.this.window.getComponentOrientation().isLeftToRight();
            int w = MetroTitlePane.this.getWidth();
            int y = 0;
            int iconifyWidth = MetroTitlePane.this.iconifyButton != null && MetroTitlePane.this.iconifyButton.getIcon() != null ? MetroTitlePane.this.iconifyButton.getIcon().getIconWidth() : 16;
            int toggleWidth = MetroTitlePane.this.toggleButton != null && MetroTitlePane.this.toggleButton.getIcon() != null ? MetroTitlePane.this.toggleButton.getIcon().getIconWidth() : 16;
            if (MetroTitlePane.this.closeButton != null && MetroTitlePane.this.closeButton.getIcon() != null) {
                buttonHeight = MetroTitlePane.this.closeButton.getIcon().getIconHeight();
                closeWidth = MetroTitlePane.this.closeButton.getIcon().getIconWidth();
            } else {
                buttonHeight = 16;
                closeWidth = 16;
            }
            int x = leftToRight ? w : 0;
            int spacing = 0;
            int n = x = leftToRight ? spacing : w - closeWidth - spacing;
            if (MetroTitlePane.this.menuBar != null) {
                MetroTitlePane.this.menuBar.setBounds(x, y, closeWidth, buttonHeight);
            }
            x = leftToRight ? w : 0;
            spacing = 0;
            x += leftToRight ? -spacing - closeWidth : spacing;
            if (MetroTitlePane.this.closeButton != null) {
                MetroTitlePane.this.closeButton.setBounds(x, y, closeWidth, buttonHeight);
            }
            if (!leftToRight) {
                x += closeWidth;
            }
            if (MetroTitlePane.this.getWindowDecorationStyle() == 1) {
                if (Toolkit.getDefaultToolkit().isFrameStateSupported(6) && MetroTitlePane.this.toggleButton.getParent() != null) {
                    spacing = 0;
                    MetroTitlePane.this.toggleButton.setBounds(x += leftToRight ? -spacing - toggleWidth : spacing, y, toggleWidth, buttonHeight);
                    if (!leftToRight) {
                        x += toggleWidth;
                    }
                }
                if (MetroTitlePane.this.iconifyButton != null && MetroTitlePane.this.iconifyButton.getParent() != null) {
                    spacing = 0;
                    MetroTitlePane.this.iconifyButton.setBounds(x += leftToRight ? -spacing - iconifyWidth : spacing, y, iconifyWidth, buttonHeight);
                    if (!leftToRight) {
                        x += iconifyWidth;
                    }
                }
            }
        }
    }

    private class SystemMenuBar
    extends JMenuBar {
        private SystemMenuBar() {
        }

        @Override
        public void paint(Graphics g) {
            if (this.isOpaque()) {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            if (MetroTitlePane.this.systemIcon != null) {
                g.drawImage(MetroTitlePane.this.systemIcon, 0, 0, 16, 16, null);
            }
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            return new Dimension(Math.max(16, size.width), Math.max(size.height, 16));
        }
    }

    private final class MaximizeAction
    extends AbstractAction {
        public MaximizeAction() {
            super(UIManager.getString((Object)"MetalTitlePane.maximizeTitle", MetroTitlePane.this.getLocale()));
            this.putValue("ShortDescription", MetroTitlePane.getString("maximize.Action.shortDescription"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MetroTitlePane.this.maximize();
        }
    }

    private final class RestoreAction
    extends AbstractAction {
        public RestoreAction() {
            super(UIManager.getString((Object)"MetalTitlePane.restoreTitle", MetroTitlePane.this.getLocale()));
            this.putValue("ShortDescription", MetroTitlePane.getString("restore.Action.shortDescription"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MetroTitlePane.this.restore();
        }
    }

    private final class IconifyAction
    extends AbstractAction {
        public IconifyAction() {
            super(UIManager.getString((Object)"MetalTitlePane.iconifyTitle", MetroTitlePane.this.getLocale()));
            this.putValue("ShortDescription", MetroTitlePane.getString("iconify.Action.shortDescription"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MetroTitlePane.this.iconify();
        }
    }

    private final class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(UIManager.getString((Object)"MetalTitlePane.closeTitle", MetroTitlePane.this.getLocale()));
            this.putValue("ShortDescription", MetroTitlePane.getString("close.Action.shortDescription"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MetroTitlePane.this.close();
        }
    }
}

