/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.decoration;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;

final class MetroBorders {
    MetroBorders() {
    }

    static class MaximizedFrameBorder
    extends BorderUIResource.EmptyBorderUIResource {
        public MaximizedFrameBorder() {
            super(0, 0, 0, 0);
        }
    }

    static class DefaultFrameBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(1, 1, 1, 1);

        DefaultFrameBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            Color leftRightBottom;
            Color top;
            Window window = SwingUtilities.getWindowAncestor(c);
            if (window != null && window.isActive()) {
                top = new Color(74, 106, 149);
                leftRightBottom = new Color(230, 230, 230);
            } else {
                top = new Color(219, 221, 226);
                leftRightBottom = new Color(188, 188, 188);
            }
            Color old = g.getColor();
            g.setColor(top);
            g.fillRect(1, 0, w - 2, 1);
            g.setColor(leftRightBottom);
            g.fillRect(0, 0, 1, h - 1);
            g.fillRect(w - 1, 0, 1, h - 1);
            g.fillRect(0, h - 1, w, 1);
            g.setColor(old);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return INSETS;
        }

        @Override
        public Insets getBorderInsets(Component c, Insets newInsets) {
            newInsets.top = DefaultFrameBorder.INSETS.top;
            newInsets.left = DefaultFrameBorder.INSETS.left;
            newInsets.bottom = DefaultFrameBorder.INSETS.bottom;
            newInsets.right = DefaultFrameBorder.INSETS.right;
            return newInsets;
        }
    }
}

