/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks;

import com.jgoodies.common.base.SystemUtils;
import com.jgoodies.looks.MicroLayout;
import com.jgoodies.looks.MicroLayoutPolicy;
import com.jgoodies.looks.MicroLayouts;
import javax.swing.UIDefaults;

public final class MicroLayoutPolicies {
    private MicroLayoutPolicies() {
    }

    public static MicroLayoutPolicy getDefaultPlasticPolicy() {
        return new DefaultPlasticPolicy();
    }

    public static MicroLayoutPolicy getDefaultWindowsPolicy() {
        return new DefaultWindowsPolicy();
    }

    private static final class DefaultWindowsPolicy
    implements MicroLayoutPolicy {
        private DefaultWindowsPolicy() {
        }

        @Override
        public MicroLayout getMicroLayout(String lafName, UIDefaults table) {
            boolean isClassic = !SystemUtils.IS_LAF_WINDOWS_XP_ENABLED;
            boolean isModern = SystemUtils.IS_OS_WINDOWS_6_OR_LATER;
            boolean isLowRes = SystemUtils.IS_LOW_RESOLUTION;
            if (isClassic) {
                return isLowRes ? MicroLayouts.createWindowsClassicLowResMicroLayout() : MicroLayouts.createWindowsClassicHiResMicroLayout();
            }
            if (isModern) {
                return isLowRes ? MicroLayouts.createWindowsModernLowResMicroLayout() : MicroLayouts.createWindowsModernHiResMicroLayout();
            }
            return isLowRes ? MicroLayouts.createWindowsXPLowResMicroLayout() : MicroLayouts.createWindowsXPHiResMicroLayout();
        }
    }

    private static final class DefaultPlasticPolicy
    implements MicroLayoutPolicy {
        private DefaultPlasticPolicy() {
        }

        @Override
        public MicroLayout getMicroLayout(String lafName, UIDefaults table) {
            boolean isLowRes = SystemUtils.IS_LOW_RESOLUTION;
            if ("JGoodies Plastic".equals(lafName)) {
                return isLowRes ? MicroLayouts.createPlasticLowResMicroLayout() : MicroLayouts.createPlasticHiResMicroLayout();
            }
            if ("JGoodies Plastic XP".equals(lafName)) {
                return isLowRes ? MicroLayouts.createPlasticXPLowResMicroLayout() : MicroLayouts.createPlasticXPHiResMicroLayout();
            }
            return isLowRes ? MicroLayouts.createPlasticModernLoResMicroLayout() : MicroLayouts.createPlasticModernHiResMicroLayout();
        }
    }
}

