/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks;

import com.jgoodies.common.base.SystemUtils;
import java.awt.Font;
import java.awt.Toolkit;

public final class Fonts {
    public static final String SEGOE_UI_NAME = "Segoe UI";
    public static final Font SEGOE_UI_12PT = new Font("Segoe UI", 0, 12);
    public static final Font SEGOE_UI_13PT = new Font("Segoe UI", 0, 13);
    public static final Font SEGOE_UI_15PT = new Font("Segoe UI", 0, 15);
    static final String WINDOWS_DEFAULT_GUI_FONT_KEY = "win.defaultGUI.font";
    static final String WINDOWS_ICON_FONT_KEY = "win.icon.font";

    private Fonts() {
    }

    public static Font getWindowsControlFont() {
        if (!SystemUtils.IS_OS_WINDOWS) {
            throw new UnsupportedOperationException("The Windows control font can be computed only on the Windows platform.");
        }
        return Fonts.getIconFont();
    }

    private static Font getIconFont() {
        Font font = Fonts.getDesktopFont(WINDOWS_ICON_FONT_KEY);
        return font != null ? font : Fonts.getFallbackFont();
    }

    private static Font getFallbackFont() {
        return new Font("Dialog", 0, 12);
    }

    private static Font getDesktopFont(String fontName) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        return (Font)toolkit.getDesktopProperty(fontName);
    }
}

