/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.proxy.http;

import com.xk72.proxy.Fields;
import com.xk72.proxy.http.HttpFieldsException;
import com.xk72.proxy.http.XaRp;
import com.xk72.proxy.http.eaPA;
import com.xk72.proxy.http.uAtD;
import com.xk72.proxy.io.MfoV;
import com.xk72.proxy.io.uAkK;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpFields
extends Fields
implements Cloneable {
    private static final Logger uQqp = Logger.getLogger("com.xk72.proxy.http.HttpFields");
    private static final long serialVersionUID = 801536825957185047L;
    private String firstLine;
    private transient uAtD AhDU;
    private transient XaRp PRdh;
    private transient long Idso = -1L;
    private transient long Vvaz = -1L;
    private static final int Hylk = 32768;

    public void setRawSize(long l) {
        this.Idso = l;
    }

    public long getRawSize() {
        return this.Idso;
    }

    public void setReceiveTime(long l) {
        this.Vvaz = l;
    }

    public long getReceiveTime() {
        return this.Vvaz;
    }

    private void readObject(ObjectInputStream objectInputStream) {
        this.fieldNames = (ArrayList)objectInputStream.readObject();
        this.fieldValues = (ArrayList)objectInputStream.readObject();
        this.firstLine = (String)objectInputStream.readObject();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.writeObject(this.fieldNames);
        objectOutputStream.writeObject(this.fieldValues);
        objectOutputStream.writeObject(this.firstLine);
    }

    @Override
    public void reset() {
        super.reset();
        this.firstLine = null;
        this.AhDU = null;
        this.PRdh = null;
        this.Idso = -1L;
        this.Vvaz = -1L;
    }

    @Override
    public void read(MfoV mfoV, boolean bl) {
        this.firstLine = null;
        this.AhDU = null;
        this.PRdh = null;
        this.Idso = -1L;
        this.Vvaz = -1L;
        if (this.readFirstLine(mfoV, bl)) {
            super.read(mfoV, bl);
        } else {
            super.reset();
        }
    }

    protected boolean readFirstLine(MfoV mfoV, boolean bl) {
        if (this.XdKP(mfoV, bl)) {
            this.firstLine = mfoV.g_();
            if (this.firstLine == null) {
                throw new EOFException("EOF reading HTTP headers");
            }
            while (uAkK.XdKP(this.firstLine).length() == 0) {
                this.firstLine = mfoV.g_();
                if (this.firstLine != null) continue;
                throw new EOFException("EOF reading HTTP headers");
            }
            this.firstLine = this.firstLine.indexOf("HTTP/") == -1 ? null : uAkK.XdKP(this.firstLine);
            try {
                if (bl) {
                    this.XdKP();
                } else {
                    this.eCYm();
                }
            }
            catch (HttpFieldsException httpFieldsException) {
                this.firstLine = null;
            }
        }
        return this.firstLine != null;
    }

    private boolean XdKP(MfoV mfoV, boolean bl) {
        byte[] byArray = new byte[128];
        int n = 0;
        try {
            while (true) {
                int n2;
                if ((n2 = mfoV.read(byArray, n, byArray.length - n)) < 0) {
                    boolean bl2 = true;
                    return bl2;
                }
                Boolean bl3 = eaPA.XdKP(bl, byArray, 0, n += n2);
                if (Boolean.TRUE.equals(bl3)) {
                    boolean bl4 = true;
                    return bl4;
                }
                if (Boolean.FALSE.equals(bl3)) {
                    boolean bl5 = false;
                    return bl5;
                }
                if (n != byArray.length) continue;
                if (n == 32768) {
                    boolean bl6 = false;
                    return bl6;
                }
                byte[] byArray2 = new byte[byArray.length * 2];
                System.arraycopy(byArray, 0, byArray2, 0, n);
                byArray = byArray2;
            }
        }
        finally {
            mfoV.unread(byArray, 0, n);
        }
    }

    @Override
    protected void write(ByteArrayOutputStream byteArrayOutputStream) {
        if (!this.isEmpty()) {
            this.writeFirstLine(byteArrayOutputStream);
            super.write(byteArrayOutputStream);
        }
    }

    public boolean isEmpty() {
        return this.firstLine == null;
    }

    protected void writeFirstLine(ByteArrayOutputStream byteArrayOutputStream) {
        byteArrayOutputStream.write(uAkK.eCYm(this.firstLine));
        byteArrayOutputStream.write(eCYm);
    }

    public String getFirstLine() {
        return this.firstLine;
    }

    public void setFirstLine(String string) {
        this.firstLine = string;
        this.AhDU = null;
        this.PRdh = null;
    }

    private uAtD XdKP() {
        if (this.AhDU == null) {
            this.AhDU = new uAtD(this.firstLine);
        }
        return this.AhDU;
    }

    private XaRp eCYm() {
        if (this.PRdh == null) {
            this.PRdh = new XaRp(this.firstLine);
        }
        return this.PRdh;
    }

    public String getRequestMethod() {
        return this.XdKP().XdKP();
    }

    public String getRequestString() {
        return this.XdKP().eCYm();
    }

    public String getRequestProtocolVersion() {
        return this.XdKP().uQqp();
    }

    public String getResponseProtocolVersion() {
        return this.eCYm().eCYm();
    }

    public int getResponseStatus() {
        try {
            return this.eCYm().XdKP();
        }
        catch (HttpFieldsException httpFieldsException) {
            return -1;
        }
    }

    public void setResponseStatus(int n, String string) {
        this.setResponseStatus(null, n, string);
    }

    public void setResponseStatus(String string, int n, String string2) {
        String string3 = string;
        if (string3 == null) {
            try {
                string3 = this.getResponseProtocolVersion();
            }
            catch (HttpFieldsException httpFieldsException) {
                string3 = "HTTP/1.1";
            }
        }
        if (string2 != null) {
            this.setFirstLine(string3 + " " + n + " " + string2);
        } else {
            this.setFirstLine(string3 + " " + n);
        }
    }

    public void setConnect(String string, int n, String string2) {
        String string3 = string2;
        if (string3 == null) {
            try {
                string3 = this.getRequestProtocolVersion();
            }
            catch (HttpFieldsException httpFieldsException) {
                string3 = "HTTP/1.1";
            }
        }
        this.setFirstLine("CONNECT " + string + ":" + (n < 0 ? 443 : n) + " " + string3);
    }

    public void setRequestFields(String string, String string2, String string3, int n, String string4, String string5, boolean bl) {
        String string6 = string5;
        if (string6 == null) {
            try {
                string6 = this.getRequestProtocolVersion();
            }
            catch (HttpFieldsException httpFieldsException) {
                string6 = "HTTP/1.1";
            }
        }
        if (bl) {
            this.setFirstLine(string + " " + string2 + "://" + string3 + (String)(n < 0 ? "" : ":" + n) + string4 + " " + string6);
        } else {
            this.setFirstLine(string + " " + string4 + " " + string6);
        }
    }

    public String getResponseStatusDescription() {
        return this.eCYm().uQqp();
    }

    public double getHttpVersion() {
        if (this.firstLine != null) {
            int n = this.firstLine.lastIndexOf("HTTP/");
            if (n != -1) {
                int n2 = this.firstLine.indexOf(32, n);
                try {
                    if (n2 != -1) {
                        return Double.parseDouble(this.firstLine.substring(n + 5, n2));
                    }
                    return Double.parseDouble(this.firstLine.substring(n + 5));
                }
                catch (NumberFormatException numberFormatException) {
                    uQqp.log(Level.WARNING, numberFormatException.toString(), numberFormatException);
                    return -1.0;
                }
            }
            return -1.0;
        }
        return -1.0;
    }

    @Override
    public HttpFields clone() {
        HttpFields httpFields = new HttpFields();
        httpFields.firstLine = this.firstLine;
        httpFields.fieldNames = new ArrayList(this.fieldNames);
        httpFields.fieldValues = new ArrayList(this.fieldValues);
        return httpFields;
    }
}

