/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.proxy;

import com.xk72.charles.lib.UrlUtil;
import com.xk72.net.Location;
import com.xk72.proxy.Connection;
import com.xk72.proxy.Fields;
import com.xk72.proxy.MfoV;
import com.xk72.proxy.ProxyEventStatus;
import com.xk72.proxy.ZOpb;
import com.xk72.proxy.ssl.SSLExtension;
import java.net.InetAddress;
import java.net.URL;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ProxyEvent
extends EventObject
implements Cloneable {
    private static final long serialVersionUID = -7771798088374968838L;
    private Date startTime;
    private Date endTime;
    private Date requestBeginTime;
    private Date requestCompleteTime;
    private Date responseBeginTime;
    private Long dnsDuration;
    private Long connectDuration;
    private Long sslDuration;
    private Long clientSslDuration;
    private boolean keptAlive;
    private boolean clientKeptAlive;
    private Fields requestHeader;
    private long requestSize;
    private int requestHeaderSize;
    private int requestHandshakeSize;
    private Fields responseHeader;
    private int responseHeaderSize;
    private int responseHandshakeSize;
    private long responseSize;
    private String host;
    private String originalHost;
    private int port;
    private String path;
    private String file;
    private String query;
    private String method;
    private String protocol;
    private boolean mapped;
    private Exception exception;
    private InetAddress clientAddress;
    private InetAddress clientLocalAddress;
    private int clientPort;
    private int clientLocalPort;
    private int remotePort;
    private int remoteLocalPort;
    private String protocolVersion;
    private InetAddress remoteAddress;
    private String externalProxyProtocol;
    private InetAddress proxyAddress;
    private int proxyPort;
    private int defaultPort = -1;
    private byte[] receivingBuffer;
    private int receivingBufferLength;
    private final Map<Object, Object> attributes = new HashMap<Object, Object>();
    private ProxyEventStatus status;
    private boolean requestBodyDecoded;
    private boolean responseBodyDecoded;
    private boolean wantResponseBodyDecoded;
    private boolean bufferResponseBody;
    private boolean bufferRequestBody;
    private boolean tunnel;
    private boolean webSocket;
    private String cipherSuite;
    private String clientCipherSuite;
    private String sslProtocol;
    private String proposedSslProtocol;
    private String clientSslProtocol;
    private String clientProposedSslProtocol;
    private byte[] sslSessionID;
    private byte[] clientSslSessionID;
    private byte[] proposedSslSessionID;
    private byte[] clientProposedSslSessionID;
    private String alpnProtocol;
    private List<String> proposedCipherSuites;
    private List<String> clientProposedCipherSuites;
    private List<String> proposedAlpnProtocols;
    private List<String> clientProposedAlpnProtocols;
    private List<Certificate> clientCerts;
    private List<Certificate> certs;
    private List<SSLExtension> clientProposedExtensions;
    private List<SSLExtension> clientExtensions;
    private List<SSLExtension> proposedExtensions;
    private List<SSLExtension> serverExtensions;
    private byte sslAlert;
    private Map<String, String> connectionAttributes;
    private Set<String> tags;
    public static final String NOTES_ATTRIBUTE = "com.xk72.charles.NOTES";
    private Connection connection;

    public ProxyEvent(MfoV mfoV) {
        super(mfoV);
    }

    public void initWithClientConnection(Connection connection, ZOpb zOpb) {
        this.connection = connection;
        this.setClientAddress(zOpb.AhDU());
        this.setClientPort(zOpb.PRdh());
        this.setClientLocalAddress(zOpb.Idso());
        this.setClientLocalPort(zOpb.Vvaz());
        this.setConnectionAttribute("Client Connection", "#" + System.identityHashCode(this.connection));
    }

    public void initWithTransaction(Connection connection, ProxyEvent proxyEvent) {
        this.connection = connection;
        this.setClientAddress(proxyEvent.getClientAddress());
        this.setClientPort(proxyEvent.getClientPort());
        this.setClientLocalAddress(proxyEvent.getClientLocalAddress());
        this.setClientLocalPort(proxyEvent.getClientLocalPort());
        this.setDefaultPort(proxyEvent.getDefaultPort());
        this.setConnectionAttribute("Client Connection", "#" + System.identityHashCode(this.connection));
    }

    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.method != null) {
            stringBuffer.append(this.method);
            stringBuffer.append(" ");
        }
        if (this.protocol != null) {
            stringBuffer.append(this.protocol);
            stringBuffer.append("://");
        }
        stringBuffer.append(this.host);
        if (this.port != -1) {
            stringBuffer.append(":");
            stringBuffer.append(this.port);
        }
        if (this.file != null) {
            stringBuffer.append(this.file);
        }
        return stringBuffer.toString();
    }

    public URL toURL() {
        return UrlUtil.XdKP(this.protocol, this.host, this.port, this.file != null ? this.file : "");
    }

    public Location toLocation() {
        return new Location(this.protocol, this.host, this.getPortOrDefault(), this.path, this.query);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("ProxyTransactionEvent could not clone itself: " + cloneNotSupportedException);
        }
    }

    public int getPortOrDefault() {
        int n = this.getPort();
        if (n != -1) {
            return n;
        }
        return this.getDefaultPort();
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date date) {
        this.startTime = date;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date date) {
        this.endTime = date;
    }

    public void setTransactionEndIfUnset(Date date) {
        if (this.endTime == null) {
            this.endTime = date;
        }
    }

    public Date getRequestBeginTime() {
        return this.requestBeginTime;
    }

    public void setRequestBeginTime(Date date) {
        this.requestBeginTime = date;
    }

    public Date getRequestCompleteTime() {
        return this.requestCompleteTime;
    }

    public void setRequestCompleteTime(Date date) {
        this.requestCompleteTime = date;
    }

    public Date getResponseBeginTime() {
        return this.responseBeginTime;
    }

    public void setResponseBeginTime(Date date) {
        this.responseBeginTime = date;
    }

    public Fields getRequestHeader() {
        return this.requestHeader;
    }

    public void setRequestHeader(Fields fields) {
        this.requestHeader = fields;
    }

    public Fields getResponseHeader() {
        return this.responseHeader;
    }

    public void setResponseHeader(Fields fields) {
        this.responseHeader = fields;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        if (this.host != null && !this.host.equals(string)) {
            this.mapped = true;
        }
        this.host = string;
    }

    public String getOriginalHost() {
        return this.originalHost;
    }

    public void setOriginalHost(String string) {
        this.originalHost = string;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        if (n != -1 && this.port > 0 && this.port != n) {
            this.mapped = true;
        }
        this.port = n;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String string) {
        if (this.protocol != null && !this.protocol.equals(string)) {
            this.mapped = true;
        }
        this.protocol = string;
    }

    public boolean isMapped() {
        return this.mapped;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        this.path = string;
        this.XdKP();
    }

    private void XdKP() {
        this.file = this.path != null ? (this.query != null ? this.path + "?" + this.query : this.path) : (this.query != null ? "?" + this.query : null);
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String string) {
        if (string != null) {
            int n = string.indexOf(63);
            if (n != -1) {
                this.path = string.substring(0, n);
                this.query = string.substring(n + 1);
            } else {
                this.path = string;
                this.query = null;
            }
        } else {
            this.path = null;
            this.query = null;
        }
        this.XdKP();
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String string) {
        this.query = string;
        this.XdKP();
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String string) {
        this.method = string;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public InetAddress getClientAddress() {
        return this.clientAddress;
    }

    public void setClientAddress(InetAddress inetAddress) {
        this.clientAddress = inetAddress;
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(String string) {
        this.protocolVersion = string;
    }

    public InetAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setRemoteAddress(InetAddress inetAddress) {
        this.remoteAddress = inetAddress;
    }

    public String getExternalProxyProtocol() {
        return this.externalProxyProtocol;
    }

    public void setExternalProxyProtocol(String string) {
        this.externalProxyProtocol = string;
    }

    public InetAddress getProxyAddress() {
        return this.proxyAddress;
    }

    public void setProxyAddress(InetAddress inetAddress) {
        this.proxyAddress = inetAddress;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int n) {
        this.proxyPort = n;
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    public void setDefaultPort(int n) {
        this.defaultPort = n;
    }

    public long getRequestSize() {
        return this.requestSize;
    }

    public void setRequestSize(long l) {
        this.requestSize = l;
    }

    public long getResponseSize() {
        return this.responseSize;
    }

    public void setResponseSize(long l) {
        this.responseSize = l;
    }

    public byte[] getReceivingBuffer() {
        return this.receivingBuffer;
    }

    public void setReceivingBuffer(byte[] byArray) {
        this.receivingBuffer = byArray;
    }

    public int getReceivingBufferLength() {
        return this.receivingBufferLength;
    }

    public void setReceivingBufferLength(int n) {
        this.receivingBufferLength = n;
    }

    public Object getAttribute(Object object) {
        return this.attributes.get(object);
    }

    public void setAttribute(Object object, Object object2) {
        this.attributes.put(object, object2);
    }

    public void removeAttribute(Object object) {
        this.attributes.remove(object);
    }

    public List<?> getListAttribute(Object object) {
        Object object2 = this.getAttribute(object);
        if (object2 != null) {
            if (object2 instanceof List) {
                return (List)object2;
            }
            return Collections.singletonList(object2);
        }
        return null;
    }

    public void addToListAttribute(Object object, Object object2) {
        Object object3 = this.getAttribute(object);
        if (object3 != null) {
            if (object3 instanceof List) {
                ((List)object3).add(object2);
            } else {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(object3);
                arrayList.add(object2);
                this.setAttribute(object, arrayList);
            }
        } else {
            this.setAttribute(object, object2);
        }
    }

    public int getResponseHeaderSize() {
        return this.responseHeaderSize;
    }

    public void setResponseHeaderSize(int n) {
        this.responseHeaderSize = n;
    }

    public int getRequestHeaderSize() {
        return this.requestHeaderSize;
    }

    public void setRequestHeaderSize(int n) {
        this.requestHeaderSize = n;
    }

    public int getResponseHandshakeSize() {
        return this.responseHandshakeSize;
    }

    public void setResponseHandshakeSize(int n) {
        this.responseHandshakeSize = n;
    }

    public int getRequestHandshakeSize() {
        return this.requestHandshakeSize;
    }

    public void setRequestHandshakeSize(int n) {
        this.requestHandshakeSize = n;
    }

    public ProxyEventStatus getStatus() {
        return this.status;
    }

    public void setStatus(ProxyEventStatus proxyEventStatus) {
        this.status = proxyEventStatus;
    }

    public boolean isRequestBodyDecoded() {
        return this.requestBodyDecoded;
    }

    public void setRequestBodyDecoded(boolean bl) {
        this.requestBodyDecoded = bl;
    }

    public boolean isResponseBodyDecoded() {
        return this.responseBodyDecoded;
    }

    public void setResponseBodyDecoded(boolean bl) {
        this.responseBodyDecoded = bl;
    }

    public boolean isWantResponseBodyDecoded() {
        return this.wantResponseBodyDecoded;
    }

    public void setWantResponseBodyDecoded() {
        this.wantResponseBodyDecoded = true;
    }

    public boolean isBufferResponseBody() {
        return this.bufferResponseBody;
    }

    public void setBufferResponseBody() {
        this.bufferResponseBody = true;
    }

    public boolean isBufferRequestBody() {
        return this.bufferRequestBody;
    }

    public void setBufferRequestBody() {
        this.bufferRequestBody = true;
    }

    public int getClientPort() {
        return this.clientPort;
    }

    public void setClientPort(int n) {
        this.clientPort = n;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void setRemotePort(int n) {
        this.remotePort = n;
    }

    public InetAddress getClientLocalAddress() {
        return this.clientLocalAddress;
    }

    public void setClientLocalAddress(InetAddress inetAddress) {
        this.clientLocalAddress = inetAddress;
    }

    public int getClientLocalPort() {
        return this.clientLocalPort;
    }

    public void setClientLocalPort(int n) {
        this.clientLocalPort = n;
    }

    public int getRemoteLocalPort() {
        return this.remoteLocalPort;
    }

    public void setRemoteLocalPort(int n) {
        this.remoteLocalPort = n;
    }

    public Long getDnsDuration() {
        return this.dnsDuration;
    }

    public void setDnsDuration(Long l) {
        this.dnsDuration = l;
    }

    public Long getConnectDuration() {
        return this.connectDuration;
    }

    public void setConnectDuration(Long l) {
        this.connectDuration = l;
    }

    public Long getSslDuration() {
        return this.sslDuration;
    }

    public void setSslDuration(Long l) {
        this.sslDuration = l;
    }

    public Long getClientSslDuration() {
        return this.clientSslDuration;
    }

    public void setClientSslDuration(Long l) {
        this.clientSslDuration = l;
    }

    public boolean isKeptAlive() {
        return this.keptAlive;
    }

    public void setKeptAlive(boolean bl) {
        this.keptAlive = bl;
    }

    public boolean isClientKeptAlive() {
        return this.clientKeptAlive;
    }

    public void setClientKeptAlive(boolean bl) {
        this.clientKeptAlive = bl;
    }

    public boolean isTunnel() {
        return this.tunnel;
    }

    public void setTunnel(boolean bl) {
        this.tunnel = bl;
    }

    public boolean isWebSocket() {
        return this.webSocket;
    }

    public void setWebSocket(boolean bl) {
        this.webSocket = bl;
    }

    public String getCipherSuite() {
        return this.cipherSuite;
    }

    public void setCipherSuite(String string) {
        this.cipherSuite = string;
    }

    public String getClientCipherSuite() {
        return this.clientCipherSuite;
    }

    public void setClientCipherSuite(String string) {
        this.clientCipherSuite = string;
    }

    public List<String> getClientProposedCipherSuites() {
        return this.clientProposedCipherSuites;
    }

    public void setClientProposedCipherSuites(List<String> list) {
        this.clientProposedCipherSuites = list;
    }

    public List<String> getProposedCipherSuites() {
        return this.proposedCipherSuites;
    }

    public void setProposedCipherSuites(List<String> list) {
        this.proposedCipherSuites = list;
    }

    public byte[] getSslSessionID() {
        return this.sslSessionID;
    }

    public void setSslSessionID(byte[] byArray) {
        this.sslSessionID = byArray;
    }

    public byte[] getClientSslSessionID() {
        return this.clientSslSessionID;
    }

    public void setClientSslSessionID(byte[] byArray) {
        this.clientSslSessionID = byArray;
    }

    public byte[] getProposedSslSessionID() {
        return this.proposedSslSessionID;
    }

    public void setProposedSslSessionID(byte[] byArray) {
        this.proposedSslSessionID = byArray;
    }

    public byte[] getClientProposedSslSessionID() {
        return this.clientProposedSslSessionID;
    }

    public void setClientProposedSslSessionID(byte[] byArray) {
        this.clientProposedSslSessionID = byArray;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public void setSslProtocol(String string) {
        this.sslProtocol = string;
    }

    public String getProposedSslProtocol() {
        return this.proposedSslProtocol;
    }

    public void setProposedSslProtocol(String string) {
        this.proposedSslProtocol = string;
    }

    public String getClientSslProtocol() {
        return this.clientSslProtocol;
    }

    public void setClientSslProtocol(String string) {
        this.clientSslProtocol = string;
    }

    public String getClientProposedSslProtocol() {
        return this.clientProposedSslProtocol;
    }

    public void setClientProposedSslProtocol(String string) {
        this.clientProposedSslProtocol = string;
    }

    public List<SSLExtension> getClientExtensions() {
        return this.clientExtensions;
    }

    public void setClientExtensions(List<SSLExtension> list) {
        this.clientExtensions = list;
    }

    public List<SSLExtension> getServerExtensions() {
        return this.serverExtensions;
    }

    public void setServerExtensions(List<SSLExtension> list) {
        this.serverExtensions = list;
    }

    public List<SSLExtension> getClientProposedExtensions() {
        return this.clientProposedExtensions;
    }

    public void setClientProposedExtensions(List<SSLExtension> list) {
        this.clientProposedExtensions = list;
    }

    public List<SSLExtension> getProposedExtensions() {
        return this.proposedExtensions;
    }

    public void setProposedExtensions(List<SSLExtension> list) {
        this.proposedExtensions = list;
    }

    public byte getSslAlert() {
        return this.sslAlert;
    }

    public void setSslAlert(byte by) {
        this.sslAlert = by;
    }

    public Map<String, String> getConnectionAttributes() {
        return this.connectionAttributes;
    }

    public void setConnectionAttribute(String string, String string2) {
        if (this.connectionAttributes == null) {
            this.connectionAttributes = new LinkedHashMap<String, String>();
        }
        this.connectionAttributes.put(string, string2);
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public void addTag(String string) {
        if (this.tags == null) {
            this.tags = new LinkedHashSet<String>();
        }
        this.tags.add(string);
    }

    public String getAlpnProtocol() {
        return this.alpnProtocol;
    }

    public void setAlpnProtocol(String string) {
        this.alpnProtocol = string;
    }

    public List<String> getClientProposedAlpnProtocols() {
        return this.clientProposedAlpnProtocols;
    }

    public void setClientProposedAlpnProtocols(List<String> list) {
        this.clientProposedAlpnProtocols = list;
    }

    public List<String> getProposedAlpnProtocols() {
        return this.proposedAlpnProtocols;
    }

    public void setProposedAlpnProtocols(List<String> list) {
        this.proposedAlpnProtocols = list;
    }

    public List<Certificate> getClientCertificates() {
        return this.clientCerts;
    }

    public void setClientCertificates(List<Certificate> list) {
        this.clientCerts = list;
    }

    public List<Certificate> getServerCertificates() {
        return this.certs;
    }

    public void setServerCertificates(List<Certificate> list) {
        this.certs = list;
    }

    public void setSslInfo(ProxyEvent proxyEvent) {
        this.setCipherSuite(proxyEvent.getCipherSuite());
        this.setClientProposedCipherSuites(proxyEvent.getClientProposedCipherSuites());
        this.setClientCipherSuite(proxyEvent.getClientCipherSuite());
        this.setProposedCipherSuites(proxyEvent.getProposedCipherSuites());
        this.setSslSessionID(proxyEvent.getSslSessionID());
        this.setClientSslSessionID(proxyEvent.getClientSslSessionID());
        this.setProposedSslSessionID(proxyEvent.getProposedSslSessionID());
        this.setClientProposedSslSessionID(proxyEvent.getClientProposedSslSessionID());
        this.setSslProtocol(proxyEvent.getSslProtocol());
        this.setProposedSslProtocol(proxyEvent.getProposedSslProtocol());
        this.setClientSslProtocol(proxyEvent.getClientSslProtocol());
        this.setClientProposedSslProtocol(proxyEvent.getClientProposedSslProtocol());
        this.setAlpnProtocol(proxyEvent.getAlpnProtocol());
        this.setClientProposedAlpnProtocols(proxyEvent.getClientProposedAlpnProtocols());
        this.setProposedAlpnProtocols(proxyEvent.getProposedAlpnProtocols());
        this.setServerCertificates(proxyEvent.getServerCertificates());
        this.setClientCertificates(proxyEvent.getClientCertificates());
        this.setClientProposedExtensions(proxyEvent.getClientProposedExtensions());
        this.setClientExtensions(proxyEvent.getClientExtensions());
        this.setProposedExtensions(proxyEvent.getProposedExtensions());
        this.setServerExtensions(proxyEvent.getServerExtensions());
        this.setSslAlert(proxyEvent.getSslAlert());
    }
}

