/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.proxy;

import com.xk72.proxy.Fields$ParseException;
import com.xk72.proxy.io.MfoV;
import com.xk72.proxy.io.uAkK;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Fields
implements Serializable {
    private static final Logger uQqp = Logger.getLogger("com.xk72.proxy.Fields");
    private static final long serialVersionUID = 801536825957185048L;
    protected static final Charset XdKP = Charset.forName("ISO-8859-1");
    protected static final byte[] eCYm = "\r\n".getBytes(XdKP);
    private static final byte[] AhDU = ": ".getBytes(XdKP);
    protected ArrayList<String> fieldNames = new ArrayList();
    protected ArrayList<String> fieldValues = new ArrayList();

    public void reset() {
        this.fieldNames.clear();
        this.fieldValues.clear();
    }

    public void read(MfoV mfoV, boolean bl) {
        this.fieldNames.clear();
        this.fieldValues.clear();
        String string = mfoV.f_();
        String string2 = null;
        StringBuffer stringBuffer = null;
        while (string != null && string.length() != 0) {
            if (uQqp.isLoggable(Level.FINEST)) {
                uQqp.finest(string);
            }
            if (string.startsWith(" ")) {
                if (stringBuffer == null) {
                    throw new IOException("Found header field continuation before a header field!: \"" + string + "\"");
                }
                stringBuffer.append(string);
            } else {
                int n;
                int n2 = string.indexOf(58);
                if (n2 == 0 && (n = string.indexOf(58, 1)) > 0) {
                    n2 = n;
                }
                if (n2 == -1) {
                    if (stringBuffer != null) {
                        stringBuffer.append(' ');
                        stringBuffer.append(string);
                    } else if (string.length() > 0 && uQqp.isLoggable(Level.WARNING)) {
                        uQqp.warning("Header line broken: " + string);
                    }
                } else {
                    if (string2 != null) {
                        this.addField(string2, stringBuffer.toString().trim());
                    }
                    string2 = string.substring(0, n2).trim();
                    stringBuffer = new StringBuffer();
                    if (n2 + 1 < string.length()) {
                        stringBuffer.append(string.substring(n2 + 1));
                    }
                }
            }
            string = mfoV.f_();
        }
        if (string2 != null) {
            this.addField(string2, stringBuffer.toString().trim());
        }
        if (string == null) {
            throw new EOFException("EOF reading HTTP headers");
        }
    }

    public byte[] toByteArray() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.write(byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException("IOException during Fields.toByteArray", iOException);
        }
    }

    protected void write(ByteArrayOutputStream byteArrayOutputStream) {
        int n = this.fieldNames.size();
        for (int i = 0; i < n; ++i) {
            String string;
            String string2 = this.fieldNames.get(i);
            String string3 = string = i < this.fieldValues.size() ? this.fieldValues.get(i) : null;
            if (string == null) {
                uQqp.warning("FIELDNAMES vs FIELDVALUES SIZE MISMATCH");
            }
            byteArrayOutputStream.write(uAkK.eCYm(string2));
            byteArrayOutputStream.write(AhDU);
            if (string != null) {
                byteArrayOutputStream.write(uAkK.eCYm(string));
            }
            byteArrayOutputStream.write(eCYm);
        }
        byteArrayOutputStream.write(eCYm);
    }

    public void concat(Fields fields) {
        this.fieldNames.addAll(fields.getFieldNames());
        this.fieldValues.addAll(fields.getFieldValues());
    }

    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    public List<String> getFieldValues() {
        return this.fieldValues;
    }

    public String get(String string) {
        return this.getField(string);
    }

    public String getField(String string) {
        int n = this.indexOf(string);
        if (n != -1) {
            return this.fieldValues.get(n);
        }
        return null;
    }

    public int indexOf(String string) {
        int n = this.fieldNames.size();
        for (int i = 0; i < n; ++i) {
            String string2 = this.fieldNames.get(i);
            if (!string2.equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }

    public String getFieldName(int n) {
        return this.fieldNames.get(n);
    }

    public String getFieldValue(int n) {
        return this.fieldValues.get(n);
    }

    public int getFieldCount() {
        return this.fieldNames.size();
    }

    public int getIntField(String string) {
        return this.getIntField(string, -1);
    }

    public int getIntField(String string, int n) {
        String string2 = this.getField(string);
        if (string2 != null) {
            string2 = string2.trim();
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                int n2 = -1;
                for (int i = 1; i <= string2.length(); ++i) {
                    try {
                        n2 = Integer.parseInt(string2.substring(0, i));
                        continue;
                    }
                    catch (NumberFormatException numberFormatException2) {
                        if (i <= 1) break;
                        return n2;
                    }
                }
                throw numberFormatException;
            }
        }
        return n;
    }

    public long getLongField(String string) {
        return this.getLongField(string, -1L);
    }

    public long getLongField(String string, long l) {
        String string2 = this.getField(string);
        if (string2 != null) {
            string2 = string2.trim();
            try {
                return Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                long l2 = -1L;
                for (int i = 1; i <= string2.length(); ++i) {
                    try {
                        l2 = Long.parseLong(string2.substring(0, i));
                        continue;
                    }
                    catch (NumberFormatException numberFormatException2) {
                        if (i <= 1) break;
                        return l2;
                    }
                }
                throw numberFormatException;
            }
        }
        return l;
    }

    public String[] getFieldValues(String string) {
        int n = this.fieldNames.size();
        ArrayList<String> arrayList = null;
        for (int i = 0; i < n; ++i) {
            String string2 = this.fieldNames.get(i);
            if (!string2.equalsIgnoreCase(string)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            arrayList.add(this.fieldValues.get(i));
        }
        if (arrayList == null) {
            return null;
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public void addField(String string, String string2) {
        this.fieldNames.add(string.intern());
        this.fieldValues.add(string2 != null ? string2.intern() : null);
    }

    public void removeField(String string) {
        int n = this.fieldNames.size();
        for (int i = 0; i < n; ++i) {
            String string2 = this.fieldNames.get(i);
            if (!string2.equalsIgnoreCase(string)) continue;
            this.fieldNames.remove(i);
            this.fieldValues.remove(i);
            --i;
            --n;
        }
    }

    public Fields clone() {
        Fields fields = new Fields();
        fields.fieldNames = new ArrayList<String>(this.fieldNames);
        fields.fieldValues = new ArrayList<String>(this.fieldValues);
        return fields;
    }

    public String toString() {
        return new String(this.toByteArray(), XdKP);
    }

    public void parse(String string, boolean bl) {
        uAkK uAkK2 = new uAkK(new ByteArrayInputStream((string + "\n\n").getBytes(XdKP)));
        try {
            String string2;
            this.read(uAkK2, bl);
            while ((string2 = uAkK2.f_()) != null) {
                if (string2.isEmpty()) continue;
                if (this.getFieldCount() == 0) {
                    throw new Fields$ParseException("Invalid first line of header");
                }
                throw new Fields$ParseException("Header contained an empty line");
            }
        }
        catch (IOException iOException) {
            throw new Fields$ParseException(iOException.getMessage(), iOException);
        }
    }

    public void removeField(int n) {
        this.fieldNames.remove(n);
        this.fieldValues.remove(n);
    }

    public void setField(String string, String string2) {
        int n = this.indexOf(string);
        if (n != -1) {
            this.setField(n, string, string2);
        } else {
            this.addField(string, string2);
        }
    }

    public void setField(int n, String string, String string2) {
        this.fieldNames.set(n, string.intern());
        this.fieldValues.set(n, string2.intern());
    }

    public String getHost() {
        return this.getField("Host");
    }

    public void setHost(String string) {
        if (string == null) {
            this.removeField("Host");
        } else {
            this.setField("Host", string);
        }
    }

    public String getCookies() {
        return this.getField("Cookie");
    }

    public void setCookies(String string) {
        if (string == null) {
            this.removeField("Cookie");
        } else {
            this.setField("Cookie", string);
        }
    }

    public static int byteLength(String string) {
        return string.getBytes(XdKP).length;
    }
}

