/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.net;

import com.xk72.util.IOjK;
import com.xk72.util.Vlpk;

@Vlpk
@IOjK
public class Location
implements Cloneable {
    private String protocol;
    private String host;
    private String port;
    private String path;
    private String query;

    public Location() {
    }

    public Location(String string, String string2, String string3, String string4, String string5) {
        this.protocol = string;
        this.host = string2;
        this.port = string3;
        this.path = string4;
        this.query = string5;
    }

    @Deprecated
    public Location(String string) {
        this.setPattern(string);
    }

    public Location(String string, String string2) {
        this.protocol = string;
        this.host = string2;
    }

    public Location(String string, String string2, int n) {
        this.protocol = string;
        this.host = string2;
        this.port = n != -1 ? Integer.toString(n) : null;
    }

    public Location(String string, String string2, int n, String string3) {
        this(string, string2, n);
        this.path = string3;
    }

    public Location(String string, String string2, int n, String string3, String string4) {
        this(string, string2, n);
        this.path = string3;
        this.query = string4;
    }

    public Location clone() {
        try {
            return (Location)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }

    public Location toHostPattern() {
        if (this.query == null && this.path == null) {
            return this;
        }
        return new Location(this.protocol, this.host, this.port, null, null);
    }

    public String getHostAndPort() {
        return this.host + (String)(this.port != null ? ":" + this.port : "");
    }

    @Deprecated
    private void setPattern(String string) {
        if (string != null) {
            this.protocol = Location.protocolPart(string);
            this.host = Location.hostPart(string, true);
            this.port = Location.portPart(string, true);
            this.path = Location.pathPart(string, true);
            if (this.path != null) {
                if (this.path.endsWith("/")) {
                    this.path = this.path + "*";
                } else if (this.path.endsWith("/$")) {
                    this.path = this.path.substring(0, this.path.length() - 1);
                }
            }
            this.query = null;
        }
    }

    public static Location parseURL(String string) {
        String string2 = Location.protocolPart(string);
        String string3 = Location.hostPart(string, true);
        String string4 = Location.portPart(string, true);
        String string5 = Location.pathPart(string, true);
        return new Location(string2, string3, string4, string5, null);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String string) {
        this.protocol = string;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String string) {
        this.port = string;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String string) {
        this.query = string;
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.host == null ? 0 : this.host.hashCode());
        n2 = 31 * n2 + (this.path == null ? 0 : this.path.hashCode());
        n2 = 31 * n2 + (this.port == null ? 0 : this.port.hashCode());
        n2 = 31 * n2 + (this.protocol == null ? 0 : this.protocol.hashCode());
        n2 = 31 * n2 + (this.query == null ? 0 : this.query.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Location location = (Location)object;
        if (this.host == null ? location.host != null : !this.host.equals(location.host)) {
            return false;
        }
        if (this.path == null ? location.path != null : !this.path.equals(location.path)) {
            return false;
        }
        if (this.port == null ? location.port != null : !this.port.equals(location.port)) {
            return false;
        }
        if (this.protocol == null ? location.protocol != null : !this.protocol.equals(location.protocol)) {
            return false;
        }
        return !(this.query == null ? location.query != null : !this.query.equals(location.query));
    }

    public String toCanoncialString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.protocol != null && this.protocol.length() > 0) {
            stringBuffer.append(this.protocol);
        }
        stringBuffer.append("://");
        if (this.host != null && this.host.length() > 0) {
            stringBuffer.append(this.host);
        }
        stringBuffer.append(':');
        if (this.port != null && this.port.length() > 0) {
            stringBuffer.append(this.port);
        }
        if (this.path != null && this.path.length() > 0) {
            if (this.path.startsWith("/")) {
                stringBuffer.append(this.path);
            } else {
                stringBuffer.append('/');
                stringBuffer.append(this.path);
            }
        } else {
            stringBuffer.append('/');
        }
        stringBuffer.append('?');
        if (this.query != null && this.query.length() > 0) {
            stringBuffer.append(this.query);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.protocol != null && this.protocol.length() > 0) {
            stringBuffer.append(this.protocol);
            stringBuffer.append("://");
        }
        if (this.host != null && this.host.length() > 0) {
            stringBuffer.append(this.host);
        } else if (this.protocol != null && this.protocol.length() > 0 || this.port != null && this.port.length() > 0 || this.path == null || this.path.length() == 0) {
            stringBuffer.append('*');
        }
        if (this.port != null && this.port.length() > 0) {
            stringBuffer.append(':');
            stringBuffer.append(this.port);
        }
        if (this.path != null && this.path.length() > 0) {
            if (this.path.startsWith("/")) {
                stringBuffer.append(this.path);
            } else {
                stringBuffer.append('/');
                stringBuffer.append(this.path);
            }
        }
        if (this.query != null && this.query.length() > 0) {
            stringBuffer.append('?');
            stringBuffer.append(this.query);
        }
        return stringBuffer.toString();
    }

    @Deprecated
    public static String protocolPart(String string) {
        int n = string.indexOf("://");
        if (n != -1) {
            return string.substring(0, n);
        }
        return null;
    }

    @Deprecated
    public static String hostPart(String string, boolean bl) {
        String string2 = Location.hostPortPart(string, bl);
        if (string2 != null) {
            String string3;
            int n = string2.indexOf(58);
            if (n == -1) {
                string3 = string2;
            } else {
                if (n == 0 && bl) {
                    return null;
                }
                string3 = string2.substring(0, n);
            }
            if (!string3.equals("*")) {
                return string3;
            }
            return null;
        }
        return null;
    }

    @Deprecated
    public static String hostPart(String string) {
        return Location.hostPart(string, false);
    }

    @Deprecated
    public static String portPart(String string, boolean bl) {
        String string2 = Location.hostPortPart(string, bl);
        if (string2 != null) {
            int n = string2.indexOf(58);
            if (n == -1) {
                return null;
            }
            return string2.substring(n + 1);
        }
        return null;
    }

    @Deprecated
    public static String portPart(String string) {
        return Location.portPart(string, false);
    }

    @Deprecated
    public static String hostPortPart(String string, boolean bl) {
        int n = string.indexOf("://");
        if (n != -1) {
            string = string.substring(n + 3);
        }
        int n2 = string.indexOf(47);
        if ((string.length() == 0 || n2 == 0) && bl) {
            return null;
        }
        if (n2 != -1) {
            return string.substring(0, n2);
        }
        return string;
    }

    @Deprecated
    public static String hostPortPart(String string) {
        return Location.hostPortPart(string, false);
    }

    @Deprecated
    public static String pathPart(String string, boolean bl) {
        int n;
        int n2 = string.indexOf("://");
        if (n2 != -1) {
            string = string.substring(n2 + 3);
        }
        if ((n = string.indexOf(47)) != -1) {
            return string.substring(n);
        }
        return bl ? null : "/";
    }

    @Deprecated
    public static String pathPart(String string) {
        return Location.pathPart(string, false);
    }
}

