/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.model;

import com.xk72.charles.CharlesContext;
import com.xk72.charles.lib.UrlUtil;
import com.xk72.charles.lib.XaRp;
import com.xk72.charles.lib.mukF;
import com.xk72.charles.model.Ahbe;
import com.xk72.charles.model.Flow;
import com.xk72.charles.model.Host;
import com.xk72.charles.model.ModelEvent;
import com.xk72.charles.model.ModelNode;
import com.xk72.charles.model.UmzW;
import com.xk72.charles.model.Vorh;
import com.xk72.charles.model.bQkH;
import com.xk72.net.Location;
import com.xk72.proxy.Connection;
import com.xk72.proxy.Fields;
import com.xk72.proxy.Fields$ParseException;
import com.xk72.proxy.ProxyEventStatus;
import com.xk72.proxy.ProxyException;
import com.xk72.proxy.http.HttpFields;
import com.xk72.proxy.http.HttpUtils;
import com.xk72.proxy.http.HttpUtils$UnsupportedProtocolException;
import com.xk72.proxy.io.uAkK;
import com.xk72.proxy.ssl.OQKv;
import com.xk72.proxy.ssl.SSLExtension;
import com.xk72.proxy.ssl.SSLSnooper;
import com.xk72.proxy.websocket.WebSocketMessage;
import com.xk72.proxy.websocket.WebSocketMessage$Source;
import com.xk72.proxy.websocket.WebSocketMessage$Type;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Transaction
extends ModelNode
implements Vorh,
Cloneable {
    private static final long serialVersionUID = -8299564089223892536L;
    private String scheme;
    private String protocolVersion;
    private String protocol;
    private String host;
    private int port = -1;
    private int actualPort = -1;
    private transient String AhDU;
    private transient String PRdh;
    private String file;
    private InetAddress remoteAddress;
    private InetAddress clientAddress;
    private int clientPort;
    private int clientLocalPort;
    private int remoteLocalPort;
    private Date startTime;
    private Date endTime;
    private Date requestBeginTime;
    private Date requestCompleteTime;
    private Date responseBeginTime;
    @Deprecated
    private long transactionStart;
    private Long dnsDuration;
    private Long connectDuration;
    private Long sslDuration;
    @Deprecated
    private long transactionBeginRequest;
    @Deprecated
    private long transactionRequest;
    @Deprecated
    private long transactionResponse;
    @Deprecated
    private long transactionEnd;
    private Fields requestHeader;
    private byte[] requestBody;
    @Deprecated
    private int requestSize;
    private long requestSizeLong;
    private int requestHeaderSize;
    private int requestHandshakeSize;
    private Fields responseHeader;
    private byte[] responseBody;
    @Deprecated
    private int responseSize;
    private long responseSizeLong;
    private int responseHeaderSize;
    private int responseHandshakeSize;
    private Exception exception;
    private int status;
    private List<Transaction> referees;
    private boolean requestBodyDecoded;
    private boolean responseBodyDecoded;
    private String notes;
    private Boolean keptAlive;
    private Boolean clientKeptAlive;
    private Boolean tunnel;
    private Boolean webSocket;
    private String cipherSuite;
    private String clientCipherSuite;
    private List<String> clientProposedCipherSuites;
    private List<String> proposedCipherSuites;
    private String sslProtocol;
    private String proposedSslProtocol;
    private String clientSslProtocol;
    private String clientProposedSslProtocol;
    private String alpnProtocol;
    private List<String> clientProposedAlpnProtocols;
    private List<String> proposedAlpnProtocols;
    private List<Certificate> certs;
    private List<Certificate> clientCerts;
    private byte[] sslSessionID;
    private byte[] clientSslSessionID;
    private byte[] proposedSslSessionID;
    private byte[] clientProposedSslSessionID;
    private List<SSLExtension> clientProposedExtensions;
    private List<SSLExtension> clientExtensions;
    private List<SSLExtension> proposedExtensions;
    private List<SSLExtension> serverExtensions;
    private byte sslAlert;
    private Map<String, String> connectionAttributes;
    private volatile Set<String> tags;
    private List<WebSocketMessage> messages;
    private int messagesSent;
    private int messagesReceived;
    private int controlFramesSent;
    private int controlFramesReceived;
    private Boolean messagesDropped;
    Flow requestFlow = new Flow();
    Flow responseFlow = new Flow();
    private transient int Vvaz = CharlesContext.getInstance() != null ? CharlesContext.getInstance().getConfiguration().getRecordingConfiguration().getMaxWebSocketMessages() : -1;
    transient UmzW XdKP;
    transient UmzW eCYm;
    transient long uQqp;
    private transient Connection Hylk;

    public Transaction() {
        this(null);
    }

    public Transaction(Connection connection) {
        this.Hylk = connection;
    }

    public Connection getInterruptableChannel() {
        return this.Hylk;
    }

    public Flow getRequestFlow() {
        return this.requestFlow;
    }

    public Flow getResponseFlow() {
        return this.responseFlow;
    }

    public void clearChannel() {
        this.Hylk = null;
    }

    @Override
    public void clear() {
        super.clear();
        this.clearChannel();
        if (this.XdKP != null) {
            this.XdKP.Idso();
        }
        if (this.eCYm != null) {
            this.eCYm.Idso();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) {
        Transaction transaction = this;
        synchronized (transaction) {
            if (this.XdKP != null) {
                this.requestBody = this.XdKP.PRdh();
            }
            if (this.eCYm != null) {
                this.responseBody = this.eCYm.PRdh();
            }
            objectOutputStream.defaultWriteObject();
            if (this.XdKP != null) {
                this.requestBody = null;
            }
            if (this.eCYm != null) {
                this.responseBody = null;
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.setRequestBody(this.requestBody);
        this.setResponseBody(this.responseBody);
        this.setFile(this.file);
        if (this.actualPort == -1) {
            this.actualPort = this.port;
        }
        if (this.requestSizeLong == 0L && this.requestSize != 0) {
            this.requestSizeLong = this.requestSize;
            this.requestSize = 0;
        }
        if (this.responseSizeLong == 0L && this.responseSize != 0) {
            this.responseSizeLong = this.responseSize;
            this.responseSize = 0;
        }
        if (this.startTime == null && this.transactionStart != 0L) {
            if (this.transactionBeginRequest == 0L && this.transactionRequest != 0L) {
                this.transactionBeginRequest = this.transactionStart;
            }
            this.startTime = new Date(this.transactionStart);
            if (this.transactionEnd != 0L) {
                this.endTime = new Date(this.transactionEnd);
            }
            if (this.transactionBeginRequest != 0L) {
                this.requestBeginTime = new Date(this.transactionBeginRequest);
            }
            if (this.transactionRequest != 0L) {
                this.requestCompleteTime = new Date(this.transactionRequest);
            }
            if (this.transactionResponse != 0L) {
                this.responseBeginTime = new Date(this.transactionResponse);
            }
        }
        if (this.requestFlow == null) {
            this.requestFlow = new Flow();
        }
        if (this.responseFlow == null) {
            this.responseFlow = new Flow();
        }
        if (this.messages != null && !this.messages.isEmpty() && this.messagesSent == 0 && this.messagesReceived == 0 && this.controlFramesSent == 0 && this.controlFramesReceived == 0) {
            for (WebSocketMessage object2 : this.messages) {
                if (object2.getSource() == WebSocketMessage$Source.XdKP) {
                    if (this.XdKP(object2.getType())) {
                        ++this.controlFramesSent;
                        continue;
                    }
                    ++this.messagesSent;
                    continue;
                }
                if (this.XdKP(object2.getType())) {
                    ++this.controlFramesReceived;
                    continue;
                }
                ++this.messagesReceived;
            }
        }
        if ("CONNECT".equals(this.scheme)) {
            Object object;
            try {
                object = this.getRequestBodyStream();
                try {
                    OQKv oQKv = SSLSnooper.XdKP(new uAkK((InputStream)object));
                    this.setClientProposedSslProtocol(oQKv.XdKP().XdKP());
                    this.setClientProposedSslSessionID(oQKv.eCYm());
                    this.setClientProposedAlpnProtocols((List<String>)(oQKv.AhDU() == null ? null : new ArrayList<String>(oQKv.AhDU())));
                    this.setClientProposedCipherSuites(Stream.of(oQKv.uQqp()).map(eaPA2 -> eaPA2.XdKP()).collect(Collectors.toList()));
                    this.setClientProposedExtensions(oQKv.PRdh());
                }
                finally {
                    if (object != null) {
                        ((InputStream)object).close();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                object = this.getResponseBodyStream();
                try {
                    SSLSnooper.XdKP(new uAkK((InputStream)object), new Ahbe(this));
                }
                finally {
                    if (object != null) {
                        ((InputStream)object).close();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public byte[] getRequestBody() {
        if (this.XdKP != null) {
            return this.XdKP.PRdh();
        }
        return this.requestBody;
    }

    private static String XdKP(Fields fields) {
        if (fields != null) {
            String string = fields.getField("Content-Encoding");
            return XaRp.XdKP(string);
        }
        return null;
    }

    public String getRequestContentEncoding() {
        return Transaction.XdKP(this.requestHeader);
    }

    public boolean isRequestBodyEncoded() {
        return this.getRequestContentEncoding() != null && !this.requestBodyDecoded;
    }

    public synchronized byte[] getDecodedRequestBody() {
        if (this.isRequestBodyEncoded()) {
            byte[] byArray = this.getRequestBody();
            if (byArray != null) {
                return XaRp.XdKP(byArray, this.getRequestContentEncoding());
            }
            return null;
        }
        return this.getRequestBody();
    }

    public long getDecodedRequestSize() {
        if (this.getRequestContentEncoding() != null) {
            try {
                byte[] byArray = this.getDecodedRequestBody();
                if (byArray != null) {
                    return byArray.length;
                }
                return 0L;
            }
            catch (IOException iOException) {
                return 0L;
            }
        }
        return this.getRequestSize();
    }

    public synchronized InputStream getRequestBodyStream() {
        if (this.XdKP != null) {
            return this.XdKP.AhDU();
        }
        if (this.requestBody != null) {
            return new ByteArrayInputStream(this.requestBody);
        }
        return null;
    }

    public synchronized InputStream getDecodedRequestBodyStream() {
        String string = this.getRequestContentEncoding();
        if (string != null && !this.requestBodyDecoded) {
            InputStream inputStream = this.getRequestBodyStream();
            if (inputStream != null) {
                return XaRp.XdKP(inputStream, string);
            }
            return null;
        }
        return this.getRequestBodyStream();
    }

    public synchronized boolean hasRequestBody() {
        if (this.XdKP != null) {
            return this.XdKP.eCYm();
        }
        return this.requestBody != null;
    }

    public synchronized byte[] getResponseBody() {
        if (this.eCYm != null) {
            return this.eCYm.PRdh();
        }
        return this.responseBody;
    }

    public String getResponseContentEncoding() {
        return Transaction.XdKP(this.responseHeader);
    }

    public boolean isResponseBodyEncoded() {
        return this.getResponseContentEncoding() != null && !this.responseBodyDecoded;
    }

    public synchronized byte[] getDecodedResponseBody() {
        if (this.isResponseBodyEncoded()) {
            byte[] byArray = this.getResponseBody();
            if (byArray != null) {
                return XaRp.XdKP(byArray, this.getResponseContentEncoding());
            }
            return null;
        }
        return this.getResponseBody();
    }

    public long getDecodedResponseSize() {
        if (this.getResponseContentEncoding() != null) {
            try {
                byte[] byArray = this.getDecodedResponseBody();
                if (byArray != null) {
                    return byArray.length;
                }
                return 0L;
            }
            catch (IOException iOException) {
                return 0L;
            }
        }
        return this.getResponseSize();
    }

    public synchronized InputStream getResponseBodyStream() {
        if (this.eCYm != null) {
            return this.eCYm.AhDU();
        }
        if (this.responseBody != null) {
            return new ByteArrayInputStream(this.responseBody);
        }
        return null;
    }

    public synchronized InputStream getDecodedResponseBodyStream() {
        String string = this.getResponseContentEncoding();
        if (string != null && !this.responseBodyDecoded) {
            InputStream inputStream = this.getResponseBodyStream();
            if (inputStream != null) {
                return XaRp.XdKP(inputStream, string);
            }
            return null;
        }
        return this.getResponseBodyStream();
    }

    public boolean hasResponseBody() {
        if (this.eCYm != null) {
            return this.eCYm.eCYm();
        }
        return this.responseBody != null;
    }

    public String getFileName() {
        if (this.AhDU != null && this.file != null) {
            int n = this.AhDU.lastIndexOf(47);
            return this.file.substring(n + 1);
        }
        return this.file;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.protocol != null) {
            stringBuffer.append(this.protocol);
            stringBuffer.append("://");
        }
        stringBuffer.append(this.host);
        if (this.port != -1) {
            stringBuffer.append(":");
            stringBuffer.append(this.port);
        }
        if (this.file != null) {
            stringBuffer.append(this.file);
        }
        return stringBuffer.toString();
    }

    public URL toURL() {
        return UrlUtil.XdKP(this.protocol != null ? this.protocol : "", this.host, this.port, this.file != null ? this.file : "");
    }

    public void setURL(URL uRL) {
        this.setProtocol(uRL.getProtocol());
        this.setHost(uRL.getHost());
        this.setPort(uRL.getPort());
        this.setFile(uRL.getFile());
    }

    @Override
    public Location toLocation() {
        return new Location(this.protocol, this.host, this.getActualPort(), this.AhDU, this.PRdh);
    }

    public boolean isHttp() {
        return this.protocol != null && (this.protocol.equals("http") || this.protocol.equals("https"));
    }

    public int getResponseStatus() {
        if (this.responseHeader != null && this.responseHeader instanceof HttpFields) {
            return ((HttpFields)this.responseHeader).getResponseStatus();
        }
        return 0;
    }

    public String getResponseProtocolVersion() {
        if (this.responseHeader != null && this.responseHeader instanceof HttpFields) {
            try {
                return ((HttpFields)this.responseHeader).getResponseProtocolVersion();
            }
            catch (ProxyException proxyException) {
                return null;
            }
        }
        return null;
    }

    public Object clone() {
        Transaction transaction;
        try {
            transaction = (Transaction)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Clone Not Supported");
        }
        transaction.deepClone();
        transaction.setParent(null);
        return transaction;
    }

    @Override
    protected void deepClone() {
        super.deepClone();
        if (this.requestHeader != null) {
            this.requestHeader = this.requestHeader.clone();
        }
        if (this.responseHeader != null) {
            this.responseHeader = this.responseHeader.clone();
        }
        if (this.referees != null) {
            this.referees = new ArrayList<Transaction>(this.referees);
        }
        if (this.messages != null) {
            this.messages = new ArrayList<WebSocketMessage>(this.messages);
        }
        if (this.connectionAttributes != null) {
            this.connectionAttributes = new LinkedHashMap<String, String>(this.connectionAttributes);
        }
        if (this.tags != null) {
            this.tags = new LinkedHashSet<String>(this.tags);
        }
    }

    public Long getDnsDuration() {
        return this.dnsDuration;
    }

    public void setDnsDuration(Long l) {
        this.dnsDuration = l;
    }

    public Long getConnectDuration() {
        return this.connectDuration;
    }

    public void setConnectDuration(Long l) {
        this.connectDuration = l;
    }

    public Long getSslDuration() {
        return this.sslDuration;
    }

    public void setSslDuration(Long l) {
        this.sslDuration = l;
    }

    @Override
    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date date) {
        this.startTime = date;
    }

    @Override
    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date date) {
        this.endTime = date;
    }

    public Date getRequestBeginTime() {
        return this.requestBeginTime;
    }

    public void setRequestBeginTime(Date date) {
        this.requestBeginTime = date;
    }

    public Date getRequestCompleteTime() {
        return this.requestCompleteTime;
    }

    public void setRequestCompleteTime(Date date) {
        this.requestCompleteTime = date;
    }

    public Date getResponseBeginTime() {
        return this.responseBeginTime;
    }

    public void setResponseBeginTime(Date date) {
        this.responseBeginTime = date;
    }

    public Fields getRequestHeader() {
        return this.requestHeader;
    }

    public void setRequestHeader(Fields fields) {
        this.requestHeader = fields;
    }

    public synchronized void setRequestBody(byte[] byArray) {
        if (byArray == null || UmzW.XdKP(byArray)) {
            this.requestBody = byArray;
            this.XdKP = null;
        } else {
            this.requestBody = null;
            this.XdKP = new UmzW(byArray);
        }
    }

    public Fields getResponseHeader() {
        return this.responseHeader;
    }

    public void setResponseHeader(Fields fields) {
        this.responseHeader = fields;
    }

    public synchronized void setResponseBody(byte[] byArray) {
        if (byArray == null || UmzW.XdKP(byArray)) {
            this.responseBody = byArray;
            this.eCYm = null;
        } else {
            this.responseBody = null;
            this.eCYm = new UmzW(byArray);
        }
    }

    public String getMethod() {
        return this.scheme;
    }

    public void setMethod(String string) {
        this.scheme = string;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String string) {
        this.protocol = string;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public int getActualPort() {
        return this.actualPort;
    }

    public void setActualPort(int n) {
        this.actualPort = n;
    }

    public String getPath() {
        return this.AhDU;
    }

    public void setPath(String string) {
        this.AhDU = string;
        this.XdKP();
    }

    private void XdKP() {
        this.file = this.AhDU != null ? (this.PRdh != null ? this.AhDU + "?" + this.PRdh : this.AhDU) : (this.PRdh != null ? "?" + this.PRdh : null);
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String string) {
        if (string != null) {
            int n = string.indexOf(63);
            if (n != -1) {
                this.AhDU = string.substring(0, n);
                this.PRdh = string.substring(n + 1);
            } else {
                this.AhDU = string;
                this.PRdh = null;
            }
        } else {
            this.AhDU = null;
            this.PRdh = null;
        }
        this.XdKP();
    }

    public String getQuery() {
        return this.PRdh;
    }

    public void setQuery(String string) {
        this.PRdh = string;
        this.XdKP();
    }

    public void updateParsedRequestFields() {
        HttpFields httpFields = (HttpFields)this.getRequestHeader();
        if (httpFields.isEmpty()) {
            this.setMethod(null);
            this.setProtocolVersion(null);
            this.setProtocol(null);
            this.setHost(null);
            this.setPort(-1);
            this.setActualPort(-1);
            this.setFile(null);
        } else {
            String string = httpFields.getRequestMethod();
            this.setMethod(string);
            this.setProtocolVersion(httpFields.getRequestProtocolVersion());
            String string2 = httpFields.getRequestString();
            if (string.equals("CONNECT")) {
                int n = string2.lastIndexOf(58);
                if (n == -1) {
                    throw new Fields$ParseException("CONNECT request didn't include a port: " + string2);
                }
                String string3 = string2.substring(0, n);
                int n2 = Integer.parseInt(string2.substring(n + 1));
                this.setProtocol("https");
                this.setHost(string3);
                this.setPort(n2);
                this.setActualPort(n2);
                this.setFile(null);
                try {
                    int n3 = HttpUtils.eCYm(this.getProtocol());
                    if (n3 == n2) {
                        this.setPort(-1);
                    }
                }
                catch (HttpUtils$UnsupportedProtocolException httpUtils$UnsupportedProtocolException) {}
            } else {
                URL uRL;
                if (string2.startsWith("/")) {
                    String string4 = this.getProtocol() + "://" + httpFields.getHost() + string2;
                    try {
                        uRL = UrlUtil.XdKP(string4);
                    }
                    catch (MalformedURLException malformedURLException) {
                        throw new Fields$ParseException("Malformed request URL \"" + string4 + "\"");
                    }
                }
                try {
                    uRL = UrlUtil.XdKP(string2);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new Fields$ParseException("Malformed request URL \"" + string2 + "\"");
                }
                this.setProtocol(uRL.getProtocol());
                this.setHost(uRL.getHost());
                int n = uRL.getPort();
                this.setPort(n);
                if (n < 0) {
                    this.setActualPort(UrlUtil.XdKP(uRL));
                } else {
                    this.setActualPort(n);
                }
                this.setFile(uRL.getFile());
            }
        }
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public long getRequestSize() {
        return this.requestSizeLong;
    }

    public void setRequestSize(long l) {
        this.requestSizeLong = l;
    }

    public int getRequestHeaderSize() {
        return this.requestHeaderSize;
    }

    public void setRequestHeaderSize(int n) {
        this.requestHeaderSize = n;
    }

    public int getRequestHandshakeSize() {
        return this.requestHandshakeSize;
    }

    public void setRequestHandshakeSize(int n) {
        this.requestHandshakeSize = n;
    }

    public long getResponseSize() {
        return this.responseSizeLong;
    }

    public void setResponseSize(long l) {
        this.responseSizeLong = l;
    }

    public int getResponseHeaderSize() {
        return this.responseHeaderSize;
    }

    public void setResponseHeaderSize(int n) {
        this.responseHeaderSize = n;
    }

    public int getResponseHandshakeSize() {
        return this.responseHandshakeSize;
    }

    public void setResponseHandshakeSize(int n) {
        this.responseHandshakeSize = n;
    }

    public boolean isRequestBodyDecoded() {
        return this.requestBodyDecoded;
    }

    public void setRequestBodyDecoded(boolean bl) {
        this.requestBodyDecoded = bl;
    }

    public boolean isResponseBodyDecoded() {
        return this.responseBodyDecoded;
    }

    public void setResponseBodyDecoded(boolean bl) {
        this.responseBodyDecoded = bl;
    }

    public InetAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setRemoteAddress(InetAddress inetAddress) {
        this.remoteAddress = inetAddress;
    }

    public ProxyEventStatus getStatus() {
        return ProxyEventStatus.XdKP(this.status);
    }

    public void setStatus(ProxyEventStatus proxyEventStatus) {
        this.status = proxyEventStatus != null ? proxyEventStatus.getRawValue() : 0;
    }

    @Override
    public long getTotalRequestSize() {
        return this.getRequestSize() + (long)this.getRequestHeaderSize() + (long)this.getRequestHandshakeSize();
    }

    @Override
    public long getTotalResponseSize() {
        return this.getResponseSize() + (long)this.getResponseHeaderSize() + (long)this.getResponseHandshakeSize();
    }

    @Override
    public long getTotalSize() {
        return this.getTotalRequestSize() + this.getTotalResponseSize();
    }

    @Override
    public long getHandshakeSize() {
        return this.getRequestHandshakeSize() + this.getResponseHandshakeSize();
    }

    public long getTotalDecodedRequestSize() {
        return this.getDecodedRequestSize() + (long)this.getRequestHeaderSize() + (long)this.getRequestHandshakeSize();
    }

    public long getTotalDecodedResponseSize() {
        return this.getDecodedResponseSize() + (long)this.getResponseHeaderSize() + (long)this.getResponseHandshakeSize();
    }

    @Override
    public long getDuration() {
        return bQkH.XdKP(this, 0L);
    }

    public static String XdKP(ProxyEventStatus proxyEventStatus) {
        switch (proxyEventStatus) {
            case XdKP: {
                return "Initialising";
            }
            case eCYm: 
            case uQqp: 
            case AhDU: {
                return "Sending request header";
            }
            case PRdh: {
                return "Resolving remote host";
            }
            case Idso: {
                return "Connecting to remote host";
            }
            case Vvaz: {
                return "Connected to remote host";
            }
            case Hylk: {
                return "Sending request body";
            }
            case qvCh: {
                return "Waiting for response";
            }
            case QNPA: {
                return "Waiting for response body";
            }
            case vkEM: {
                return "Receiving response body";
            }
            case kbzH: {
                return "Received response body";
            }
            case ERKX: {
                return "Complete";
            }
            case gMxR: {
                return "Failed";
            }
            case CsNq: {
                return "Blocked";
            }
        }
        return "Unknown";
    }

    @Deprecated
    public static ProxyEventStatus XdKP(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals("Initialising")) {
            return ProxyEventStatus.XdKP;
        }
        if (string.equals("Sending request header")) {
            return ProxyEventStatus.AhDU;
        }
        if (string.equals("Resolving remote host")) {
            return ProxyEventStatus.PRdh;
        }
        if (string.equals("Connecting to remote host")) {
            return ProxyEventStatus.Idso;
        }
        if (string.equals("Connected to remote host")) {
            return ProxyEventStatus.Vvaz;
        }
        if (string.equals("Sending request body")) {
            return ProxyEventStatus.Hylk;
        }
        if (string.equals("Waiting for response")) {
            return ProxyEventStatus.qvCh;
        }
        if (string.equals("Waiting for response body")) {
            return ProxyEventStatus.QNPA;
        }
        if (string.equals("Receiving response body")) {
            return ProxyEventStatus.vkEM;
        }
        if (string.equals("Received response body")) {
            return ProxyEventStatus.kbzH;
        }
        if (string.equals("Complete")) {
            return ProxyEventStatus.ERKX;
        }
        if (string.equals("Failed") || string.equals("Exception")) {
            return ProxyEventStatus.gMxR;
        }
        if (string.equals("Blocked")) {
            return ProxyEventStatus.CsNq;
        }
        if (string.equals("Unknown")) {
            return null;
        }
        throw new IllegalArgumentException("Unrecognized status string: " + string);
    }

    public static String eCYm(ProxyEventStatus proxyEventStatus) {
        switch (proxyEventStatus) {
            case XdKP: {
                return "Initialising\u2026";
            }
            case eCYm: 
            case uQqp: {
                return "Receiving request header\u2026";
            }
            case AhDU: {
                return "Sending request header\u2026";
            }
            case PRdh: {
                return "Resolving remote host\u2026";
            }
            case Idso: {
                return "Connecting to remote host\u2026";
            }
            case Vvaz: {
                return "Connected to remote host";
            }
            case Hylk: {
                return "Sending request body\u2026";
            }
            case qvCh: {
                return "Sent request. Waiting for response\u2026";
            }
            case QNPA: {
                return "Received response header. Waiting for response body\u2026";
            }
            case vkEM: {
                return "Receiving response body\u2026";
            }
            case kbzH: {
                return "Received response";
            }
            case ERKX: {
                return "Complete";
            }
            case gMxR: {
                return "Failed";
            }
            case CsNq: {
                return "Blocked";
            }
        }
        throw new IllegalArgumentException("Unsupported ProxyEventStatus: " + proxyEventStatus);
    }

    public synchronized List<Transaction> getReferees() {
        if (this.referees != null) {
            return this.referees;
        }
        return Collections.EMPTY_LIST;
    }

    public synchronized void addReferee(Transaction transaction) {
        if (this.referees == null) {
            this.referees = new ArrayList<Transaction>();
        }
        this.referees.add(transaction);
        this.fireModelListenerModelChanged(new ModelEvent(this, transaction, true));
    }

    public synchronized void removeReferee(Transaction transaction) {
        boolean bl = false;
        if (this.referees != null) {
            bl = this.referees.remove(transaction);
        }
        if (bl) {
            this.fireModelListenerModelChanged(new ModelEvent(this, transaction, true));
        }
    }

    public String getDecodedRequestBodyAsString() {
        String string;
        byte[] byArray;
        try {
            byArray = this.getDecodedRequestBody();
        }
        catch (IOException iOException) {
            byArray = this.getRequestBody();
        }
        if (byArray == null) {
            return null;
        }
        String string2 = string = this.requestHeader != null ? mukF.uQqp(this.requestHeader) : "ISO-8859-1";
        if (string != null) {
            try {
                return new String(byArray, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new String(byArray);
            }
        }
        return new String(byArray);
    }

    public String getDecodedResponseBodyAsString() {
        String string;
        byte[] byArray;
        try {
            byArray = this.getDecodedResponseBody();
        }
        catch (IOException iOException) {
            byArray = this.getResponseBody();
        }
        if (byArray == null) {
            return null;
        }
        String string2 = string = this.responseHeader != null ? mukF.uQqp(this.responseHeader) : "ISO-8859-1";
        if (string != null) {
            try {
                return new String(byArray, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new String(byArray);
            }
        }
        return new String(byArray);
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String string) {
        this.notes = string;
    }

    public void appendNotes(String string) {
        if (this.getNotes() == null) {
            this.setNotes(string);
        } else {
            this.setNotes((this.getNotes() + "\n" + string).trim());
        }
    }

    public InetAddress getClientAddress() {
        return this.clientAddress;
    }

    public void setClientAddress(InetAddress inetAddress) {
        this.clientAddress = inetAddress;
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(String string) {
        this.protocolVersion = string;
    }

    public int getClientPort() {
        return this.clientPort;
    }

    public void setClientPort(int n) {
        this.clientPort = n;
    }

    public int getClientLocalPort() {
        return this.clientLocalPort;
    }

    public void setClientLocalPort(int n) {
        this.clientLocalPort = n;
    }

    public int getRemoteLocalPort() {
        return this.remoteLocalPort;
    }

    public void setRemoteLocalPort(int n) {
        this.remoteLocalPort = n;
    }

    @Override
    public Date getEarliestStartTime() {
        if (this.getStartTime() != null) {
            return this.getStartTime();
        }
        return null;
    }

    @Override
    public Date getLatestTime() {
        if (this.getEndTime() != null) {
            return this.getEndTime();
        }
        if (this.getResponseBeginTime() != null) {
            return this.getResponseBeginTime();
        }
        if (this.getRequestCompleteTime() != null) {
            return this.getRequestCompleteTime();
        }
        if (this.getRequestBeginTime() != null) {
            return this.getRequestBeginTime();
        }
        return this.getStartTime();
    }

    public Boolean getKeptAlive() {
        return this.keptAlive;
    }

    public void setKeptAlive(Boolean bl) {
        this.keptAlive = bl;
    }

    public Boolean getClientKeptAlive() {
        return this.clientKeptAlive;
    }

    public void setClientKeptAlive(Boolean bl) {
        this.clientKeptAlive = bl;
    }

    public Boolean getTunnel() {
        return this.tunnel;
    }

    public void setTunnel(Boolean bl) {
        this.tunnel = bl;
    }

    public Boolean getWebSocket() {
        return this.webSocket;
    }

    public void setWebSocket(Boolean bl) {
        this.webSocket = bl;
    }

    public Boolean getWebSocketMessagesDropped() {
        return this.messagesDropped;
    }

    public String getCipherSuite() {
        return this.cipherSuite;
    }

    public void setCipherSuite(String string) {
        this.cipherSuite = string;
    }

    public String getClientCipherSuite() {
        return this.clientCipherSuite;
    }

    public void setClientCipherSuite(String string) {
        this.clientCipherSuite = string;
    }

    public List<String> getClientProposedCipherSuites() {
        return this.clientProposedCipherSuites;
    }

    public void setClientProposedCipherSuites(List<String> list) {
        this.clientProposedCipherSuites = list;
    }

    public List<String> getProposedCipherSuites() {
        return this.proposedCipherSuites;
    }

    public void setProposedCipherSuites(List<String> list) {
        this.proposedCipherSuites = list;
    }

    public byte[] getSslSessionID() {
        return this.sslSessionID;
    }

    public void setSslSessionID(byte[] byArray) {
        this.sslSessionID = byArray;
    }

    public byte[] getClientSslSessionID() {
        return this.clientSslSessionID;
    }

    public void setClientSslSessionID(byte[] byArray) {
        this.clientSslSessionID = byArray;
    }

    public byte[] getProposedSslSessionID() {
        return this.proposedSslSessionID;
    }

    public void setProposedSslSessionID(byte[] byArray) {
        this.proposedSslSessionID = byArray;
    }

    public byte[] getClientProposedSslSessionID() {
        return this.clientProposedSslSessionID;
    }

    public void setClientProposedSslSessionID(byte[] byArray) {
        this.clientProposedSslSessionID = byArray;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public void setSslProtocol(String string) {
        this.sslProtocol = string;
    }

    public String getProposedSslProtocol() {
        return this.proposedSslProtocol;
    }

    public void setProposedSslProtocol(String string) {
        this.proposedSslProtocol = string;
    }

    public String getClientSslProtocol() {
        return this.clientSslProtocol;
    }

    public void setClientSslProtocol(String string) {
        this.clientSslProtocol = string;
    }

    public String getClientProposedSslProtocol() {
        return this.clientProposedSslProtocol;
    }

    public void setClientProposedSslProtocol(String string) {
        this.clientProposedSslProtocol = string;
    }

    public String getAlpnProtocol() {
        return this.alpnProtocol;
    }

    public void setAlpnProtocol(String string) {
        this.alpnProtocol = string;
        if ("h2".equals(string)) {
            ModelNode modelNode = this;
            while (modelNode != null) {
                if (!((modelNode = modelNode.getParent()) instanceof Host)) continue;
                ((Host)modelNode).setHttp2(Boolean.TRUE);
            }
        }
    }

    public List<String> getClientProposedAlpnProtocols() {
        return this.clientProposedAlpnProtocols;
    }

    public void setClientProposedAlpnProtocols(List<String> list) {
        this.clientProposedAlpnProtocols = list;
    }

    public List<String> getProposedAlpnProtocols() {
        return this.proposedAlpnProtocols;
    }

    public void setProposedAlpnProtocols(List<String> list) {
        this.proposedAlpnProtocols = list;
    }

    public List<Certificate> getClientCertificates() {
        return this.clientCerts;
    }

    public void setClientCertificates(List<Certificate> list) {
        this.clientCerts = list;
    }

    public List<Certificate> getServerCertificates() {
        return this.certs;
    }

    public void setServerCertificates(List<Certificate> list) {
        this.certs = list;
    }

    public List<SSLExtension> getClientExtensions() {
        return this.clientExtensions;
    }

    public void setClientExtensions(List<SSLExtension> list) {
        this.clientExtensions = list;
    }

    public List<SSLExtension> getServerExtensions() {
        return this.serverExtensions;
    }

    public void setServerExtensions(List<SSLExtension> list) {
        this.serverExtensions = list;
    }

    public List<SSLExtension> getClientProposedExtensions() {
        return this.clientProposedExtensions;
    }

    public void setClientProposedExtensions(List<SSLExtension> list) {
        this.clientProposedExtensions = list;
    }

    public List<SSLExtension> getProposedExtensions() {
        return this.proposedExtensions;
    }

    public void setProposedExtensions(List<SSLExtension> list) {
        this.proposedExtensions = list;
    }

    public byte getSslAlert() {
        return this.sslAlert;
    }

    public void setSslAlert(byte by) {
        this.sslAlert = by;
    }

    public Map<String, String> getConnectionAttributes() {
        return this.connectionAttributes;
    }

    public void setConnectionAttributes(Map<String, String> map) {
        if (this.connectionAttributes == null) {
            if (map != null) {
                this.connectionAttributes = new LinkedHashMap<String, String>(map);
            }
        } else {
            this.connectionAttributes.clear();
            if (map != null) {
                this.connectionAttributes.putAll(map);
            }
        }
    }

    public void setConnectionAttribute(String string, String string2) {
        if (this.connectionAttributes == null) {
            this.connectionAttributes = new LinkedHashMap<String, String>();
        }
        this.connectionAttributes.put(string, string2);
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public void setTags(Set<String> set) {
        this.tags = set == null ? null : new LinkedHashSet<String>(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTag(String string) {
        if (this.tags == null) {
            this.tags = new LinkedHashSet<String>();
        }
        Set<String> set = this.tags;
        synchronized (set) {
            this.tags.add(string);
        }
    }

    public synchronized void addClientWebSocketMessage(WebSocketMessage webSocketMessage) {
        this.XdKP(webSocketMessage);
        if (this.XdKP(webSocketMessage.getType())) {
            ++this.controlFramesSent;
        } else {
            ++this.messagesSent;
        }
    }

    public synchronized void addServerWebSocketMessage(WebSocketMessage webSocketMessage) {
        this.XdKP(webSocketMessage);
        if (this.XdKP(webSocketMessage.getType())) {
            ++this.controlFramesReceived;
        } else {
            ++this.messagesReceived;
        }
    }

    private boolean XdKP(WebSocketMessage$Type webSocketMessage$Type) {
        switch (webSocketMessage$Type) {
            case Vvaz: 
            case PRdh: 
            case Idso: 
            case Hylk: {
                return true;
            }
        }
        return false;
    }

    private void XdKP(WebSocketMessage webSocketMessage) {
        if (this.Vvaz == 0) {
            this.messagesDropped = Boolean.TRUE;
            return;
        }
        if (this.messages == null) {
            this.messages = new LinkedList<WebSocketMessage>();
        }
        this.messages.add(webSocketMessage);
        if (this.Vvaz >= 0) {
            while (this.messages.size() > this.Vvaz) {
                this.messages.remove(0);
                this.messagesDropped = Boolean.TRUE;
            }
        }
        this.fireModelListenerModelChanged(new ModelEvent(this));
    }

    public synchronized List<WebSocketMessage> getWebSocketMessages() {
        if (this.messages == null) {
            return Collections.emptyList();
        }
        return new ArrayList<WebSocketMessage>(this.messages);
    }

    public synchronized void collectWebSocketMessages(List<WebSocketMessage> list) {
        if (this.messages != null) {
            list.addAll(this.messages);
        }
    }

    public int getMessagesSent() {
        return this.messagesSent;
    }

    public int getMessagesReceived() {
        return this.messagesReceived;
    }

    public int getControlFramesSent() {
        return this.controlFramesSent;
    }

    public int getControlFramesReceived() {
        return this.controlFramesReceived;
    }
}

