/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.model;

import com.xk72.charles.lib.UrlUtil;
import com.xk72.charles.model.Path;
import com.xk72.charles.model.Transaction;
import com.xk72.net.Location;
import java.net.URL;

public class Host
extends Path {
    private static final long serialVersionUID = 4684306040161133314L;
    private String protocol;
    private String hostName;
    private int port;
    private int actualPort = -1;
    private Boolean tunnel;
    private Boolean http2;

    public static String XdKP(Host host) {
        return host.getProtocol() + (Boolean.TRUE.equals(host.getTunnel()) ? ":tunnel" : "") + "://" + host.getHostName() + ":" + host.getPort();
    }

    public static String XdKP(Transaction transaction) {
        return transaction.getProtocol() + (Boolean.TRUE.equals(transaction.getTunnel()) ? ":tunnel" : "") + "://" + transaction.getHost() + ":" + transaction.getPort();
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String string) {
        this.protocol = string;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String string) {
        this.hostName = string;
    }

    @Override
    public String toString() {
        if (this.hostName == null) {
            return "<unknown>";
        }
        return (String)(this.protocol != null ? this.protocol + "://" : "") + this.hostName + (String)(this.port != -1 ? ":" + this.port : "");
    }

    @Override
    public URL toURL() {
        if (this.protocol != null) {
            return UrlUtil.XdKP(this.protocol, this.hostName, this.port, "");
        }
        return null;
    }

    @Override
    public Location toLocation() {
        return new Location(this.protocol, this.hostName, this.getActualPort());
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public int getActualPort() {
        return this.actualPort;
    }

    public void setActualPort(int n) {
        this.actualPort = n;
    }

    public Boolean getTunnel() {
        return this.tunnel;
    }

    public void setTunnel(Boolean bl) {
        this.tunnel = bl;
    }

    public Boolean getHttp2() {
        return this.http2;
    }

    public void setHttp2(Boolean bl) {
        this.http2 = bl;
    }
}

