/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;

public class SomewhatSortedArrayList<E>
extends ArrayList<E> {
    private static final long serialVersionUID = -9013811211159402642L;
    private final Comparator<E> comparator;

    public SomewhatSortedArrayList(Comparator<E> comparator) {
        this.comparator = comparator;
    }

    public Comparator<E> getComparator() {
        return this.comparator;
    }

    @Override
    public boolean add(E e) {
        this.add(this.XdKP(e), e);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean bl = super.addAll(collection);
        if (bl) {
            Collections.sort(this, this.comparator);
        }
        return bl;
    }

    public boolean checkSorted(int n) {
        if (n < 0) {
            return true;
        }
        if (n > 0 && this.comparator.compare(this.get(n - 1), this.get(n)) > 0) {
            return false;
        }
        return n + 1 >= this.size() || this.comparator.compare(this.get(n), this.get(n + 1)) <= 0;
    }

    private int XdKP(E e) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (this.comparator.compare(this.get(i), e) <= 0) continue;
            return i;
        }
        return n;
    }
}

