/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.lib;

import com.xk72.charles.lib.AuthorizationUtils$Authorization;
import com.xk72.charles.lib.AuthorizationUtils$BasicAuthorization;
import com.xk72.charles.lib.AuthorizationUtils$Challenge;
import com.xk72.charles.lib.AuthorizationUtils$GenericAuthorization;
import com.xk72.charles.lib.AuthorizationUtils$GenericChallenge;
import com.xk72.charles.lib.AuthorizationUtils$NameValue;
import com.xk72.charles.lib.AuthorizationUtils$UnsupportedAuthorization;
import com.xk72.charles.lib.AuthorizationUtils$UnsupportedChallenge;
import com.xk72.charles.lib.BNFParser;
import com.xk72.charles.lib.BNFParser$BNFParseException;
import com.xk72.proxy.Fields;
import com.xk72.util.TUqP;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.Base64;
import java.util.List;

public class AuthorizationUtils {
    public static final String XdKP = "Digest";
    public static final String eCYm = "OAuth";
    public static final String uQqp = "Bearer";
    public static final String AhDU = "Proxy-Authenticate";
    public static final String PRdh = "Proxy-Authorization";
    public static final String Idso = "WWW-Authenticate";
    public static final String Vvaz = "Basic";
    public static final String Hylk = "NTLM";
    public static final String qvCh = "Negotiate";
    public static final String QNPA = "Authorization";

    public static AuthorizationUtils$Authorization XdKP(Fields fields) {
        String string = fields.get(QNPA);
        if (string != null) {
            return AuthorizationUtils.XdKP(string);
        }
        return null;
    }

    public static AuthorizationUtils$Authorization XdKP(String string) {
        if (string != null) {
            int n = (string = string.trim()).indexOf(32);
            if (n != -1) {
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                if (string2.equalsIgnoreCase(Vvaz)) {
                    return AuthorizationUtils.uQqp(string3);
                }
                if (string2.equalsIgnoreCase(XdKP)) {
                    return AuthorizationUtils.AhDU(string3);
                }
                if (string2.equalsIgnoreCase(eCYm)) {
                    return AuthorizationUtils.PRdh(string3);
                }
                if (string2.equalsIgnoreCase(uQqp)) {
                    return AuthorizationUtils.Idso(string3);
                }
                return AuthorizationUtils.eCYm(string2, string3);
            }
            throw new ParseException("Failed to parse authentication header: " + string, 0);
        }
        throw new NullPointerException("Authentication header was null");
    }

    public static String XdKP(AuthorizationUtils$Authorization authorizationUtils$Authorization) {
        if (authorizationUtils$Authorization instanceof AuthorizationUtils$BasicAuthorization) {
            return AuthorizationUtils.XdKP((AuthorizationUtils$BasicAuthorization)authorizationUtils$Authorization);
        }
        if (authorizationUtils$Authorization instanceof AuthorizationUtils$GenericAuthorization) {
            return AuthorizationUtils.XdKP((AuthorizationUtils$GenericAuthorization)authorizationUtils$Authorization);
        }
        throw new IllegalArgumentException("Unsupported Authorization: " + authorizationUtils$Authorization.getClass().getName());
    }

    public static AuthorizationUtils$Challenge eCYm(String string) {
        if (string != null) {
            int n = (string = string.trim()).indexOf(32);
            if (n != -1) {
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                if (string2.equalsIgnoreCase(Vvaz)) {
                    return AuthorizationUtils.Vvaz(string3);
                }
                if (string2.equalsIgnoreCase(XdKP)) {
                    return AuthorizationUtils.Hylk(string3);
                }
                if (string2.equalsIgnoreCase(eCYm)) {
                    return AuthorizationUtils.qvCh(string3);
                }
                return AuthorizationUtils.AhDU(string2, string3);
            }
            if (string.equalsIgnoreCase(Hylk)) {
                return AuthorizationUtils.AhDU(string, null);
            }
            if (string.equalsIgnoreCase(qvCh)) {
                return AuthorizationUtils.AhDU(string, null);
            }
            throw new ParseException("Failed to parse authentication challenge header: " + string, 0);
        }
        throw new NullPointerException("Authentication challenge header was null");
    }

    public static String XdKP(AuthorizationUtils$Challenge authorizationUtils$Challenge) {
        if (authorizationUtils$Challenge instanceof AuthorizationUtils$GenericChallenge) {
            return AuthorizationUtils.XdKP((AuthorizationUtils$GenericChallenge)authorizationUtils$Challenge);
        }
        throw new IllegalArgumentException("Unsupported Challenge: " + authorizationUtils$Challenge.getClass().getName());
    }

    private static AuthorizationUtils$Authorization uQqp(String string) {
        byte[] byArray;
        try {
            byArray = Base64.getDecoder().decode(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        String string2 = new String(byArray);
        int n = string2.indexOf(58);
        if (n != -1) {
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            return new AuthorizationUtils$BasicAuthorization(string, string3, string4);
        }
        return new AuthorizationUtils$BasicAuthorization(string, string2, null);
    }

    private static String XdKP(AuthorizationUtils$BasicAuthorization authorizationUtils$BasicAuthorization) {
        String string = authorizationUtils$BasicAuthorization.getUserId() + ":" + authorizationUtils$BasicAuthorization.getPassword();
        try {
            return "Basic " + Base64.getEncoder().encodeToString(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException);
        }
    }

    private static AuthorizationUtils$Authorization AhDU(String string) {
        return AuthorizationUtils.XdKP(XdKP, string);
    }

    private static AuthorizationUtils$Authorization PRdh(String string) {
        return AuthorizationUtils.XdKP(eCYm, string);
    }

    private static AuthorizationUtils$Authorization Idso(String string) {
        return new AuthorizationUtils$GenericAuthorization(uQqp, string);
    }

    private static AuthorizationUtils$GenericAuthorization XdKP(String string, String string2) {
        AuthorizationUtils$GenericAuthorization authorizationUtils$GenericAuthorization = new AuthorizationUtils$GenericAuthorization(string, string2);
        if (string2.contains("=") || string2.contains(",")) {
            BNFParser bNFParser = new BNFParser(string2);
            try {
                do {
                    String string3 = bNFParser.XdKP();
                    if (bNFParser.eCYm("=")) {
                        String string4 = bNFParser.uQqp();
                        authorizationUtils$GenericAuthorization.addParameter(string3, string4);
                        continue;
                    }
                    if (string3.length() <= 0) continue;
                    authorizationUtils$GenericAuthorization.addParameter(string3, "");
                } while (bNFParser.eCYm());
            }
            catch (BNFParser$BNFParseException bNFParser$BNFParseException) {
                authorizationUtils$GenericAuthorization.setParseException(bNFParser$BNFParseException);
            }
        }
        return authorizationUtils$GenericAuthorization;
    }

    private static String XdKP(List<AuthorizationUtils$NameValue> list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (AuthorizationUtils$NameValue authorizationUtils$NameValue : list) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(authorizationUtils$NameValue.getName());
            stringBuffer.append('=');
            stringBuffer.append('\"');
            stringBuffer.append(TUqP.XdKP(authorizationUtils$NameValue.getValue(), "\"", "\\\""));
            stringBuffer.append('\"');
        }
        return stringBuffer.toString();
    }

    private static String XdKP(AuthorizationUtils$GenericAuthorization authorizationUtils$GenericAuthorization) {
        List<AuthorizationUtils$NameValue> list = authorizationUtils$GenericAuthorization.getParameters();
        if (list != null) {
            return authorizationUtils$GenericAuthorization.getScheme() + " " + AuthorizationUtils.XdKP(list);
        }
        if (authorizationUtils$GenericAuthorization.getValue() != null && authorizationUtils$GenericAuthorization.getValue().length() > 0) {
            return authorizationUtils$GenericAuthorization.getScheme() + " " + authorizationUtils$GenericAuthorization.getValue();
        }
        return authorizationUtils$GenericAuthorization.getScheme();
    }

    private static AuthorizationUtils$Authorization eCYm(String string, String string2) {
        AuthorizationUtils$GenericAuthorization authorizationUtils$GenericAuthorization = AuthorizationUtils.XdKP(string, string2);
        if (authorizationUtils$GenericAuthorization.getParseException() == null) {
            return authorizationUtils$GenericAuthorization;
        }
        return new AuthorizationUtils$UnsupportedAuthorization(string, string2);
    }

    private static AuthorizationUtils$Challenge Vvaz(String string) {
        return AuthorizationUtils.uQqp(Vvaz, string);
    }

    private static AuthorizationUtils$Challenge Hylk(String string) {
        return AuthorizationUtils.uQqp(XdKP, string);
    }

    private static AuthorizationUtils$Challenge qvCh(String string) {
        return AuthorizationUtils.uQqp(eCYm, string);
    }

    private static AuthorizationUtils$Challenge uQqp(String string, String string2) {
        AuthorizationUtils$GenericChallenge authorizationUtils$GenericChallenge = new AuthorizationUtils$GenericChallenge(string, string2);
        BNFParser bNFParser = new BNFParser(string2);
        try {
            do {
                String string3 = bNFParser.XdKP();
                if (bNFParser.eCYm("=")) {
                    String string4 = bNFParser.uQqp();
                    authorizationUtils$GenericChallenge.addParameter(string3, string4);
                    continue;
                }
                if (string3.length() <= 0) continue;
                authorizationUtils$GenericChallenge.addParameter(string3, "");
            } while (bNFParser.eCYm());
        }
        catch (BNFParser$BNFParseException bNFParser$BNFParseException) {
            authorizationUtils$GenericChallenge.setParseException(bNFParser$BNFParseException);
        }
        return authorizationUtils$GenericChallenge;
    }

    private static String XdKP(AuthorizationUtils$GenericChallenge authorizationUtils$GenericChallenge) {
        return authorizationUtils$GenericChallenge.getScheme() + " " + AuthorizationUtils.XdKP(authorizationUtils$GenericChallenge.getParameters());
    }

    private static AuthorizationUtils$Challenge AhDU(String string, String string2) {
        return new AuthorizationUtils$UnsupportedChallenge(string, string2);
    }
}

