/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.gui.transaction.summary;

import com.xk72.charles.gui.lib.FvmR;
import com.xk72.charles.gui.lib.WXcm;
import com.xk72.charles.lib.OEqP;
import com.xk72.charles.lib.mukF;
import com.xk72.charles.lib.tfse;
import com.xk72.charles.model.ModelEvent;
import com.xk72.charles.model.ModelNode;
import com.xk72.charles.model.Transaction;
import com.xk72.charles.model.Vlpk;
import com.xk72.charles.model.bQkH;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class SummaryTableModel
extends AbstractTableModel
implements FvmR,
WXcm,
com.xk72.charles.model.mukF {
    private final List<Transaction> transactions = new ArrayList<Transaction>();
    private ModelNode[] source;
    private int size;
    private int totalHeaderBytes;
    private int totalBodyBytes;
    private long totalTimes;
    private long duration;
    private static final String[] XdKP = new String[]{"#", "Resource", "Host", "Code", "Mime Type", "Header", "Body", "Time"};
    private static final Class<?>[] eCYm = new Class[]{Integer.class, Transaction.class, String.class, Integer.class, String.class, String.class, String.class, String.class};
    private final tfse formatter = new OEqP();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void view(ModelNode[] modelNodeArray) {
        List<Transaction> list = this.transactions;
        synchronized (list) {
            for (int i = 0; i < this.size; ++i) {
                ModelNode modelNode = this.transactions.get(i);
                modelNode.removeModelListener(this);
            }
            this.source = modelNodeArray;
            this.transactions.clear();
            Vlpk vlpk = new Vlpk(this.transactions);
            vlpk.XdKP(modelNodeArray);
            if (modelNodeArray.length == 1 && modelNodeArray[0] instanceof Transaction) {
                vlpk.XdKP((Transaction)modelNodeArray[0]);
                for (int i = 1; i < this.transactions.size(); ++i) {
                    this.transactions.get(i).addModelListener(this);
                }
            }
            this.size = this.transactions.size();
            this.totalHeaderBytes = 0;
            this.totalBodyBytes = 0;
            this.totalTimes = 0L;
            Date date = null;
            Date date2 = null;
            for (int i = 0; i < this.size; ++i) {
                Transaction transaction = this.transactions.get(i);
                this.totalHeaderBytes += transaction.getResponseHeaderSize();
                this.totalBodyBytes = (int)((long)this.totalBodyBytes + transaction.getResponseSize());
                if (transaction.getStartTime() != null && (date == null || transaction.getStartTime().before(date))) {
                    date = transaction.getStartTime();
                }
                if (transaction.getEndTime() != null && (date2 == null || transaction.getEndTime().after(date2))) {
                    date2 = transaction.getEndTime();
                }
                if (transaction.getEndTime() == null || transaction.getStartTime() == null) continue;
                this.totalTimes += transaction.getEndTime().getTime() - transaction.getStartTime().getTime();
            }
            this.duration = date != null && date2 != null ? date2.getTime() - date.getTime() : 0L;
        }
        this.fireTableDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.source = null;
        List<Transaction> list = this.transactions;
        synchronized (list) {
            this.transactions.clear();
        }
        this.size = 0;
        this.totalTimes = 0L;
        this.totalHeaderBytes = 0;
        this.totalBodyBytes = 0;
        this.duration = 0L;
        this.fireTableDataChanged();
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return eCYm[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int n, int n2) {
        List<Transaction> list = this.transactions;
        synchronized (list) {
            if (n < this.size) {
                Transaction transaction = this.transactions.get(n);
                switch (n2) {
                    case 0: {
                        return n + 1;
                    }
                    case 1: {
                        return transaction;
                    }
                    case 2: {
                        if (transaction.getPort() != -1) {
                            return transaction.getHost() + ":" + transaction.getPort();
                        }
                        return transaction.getHost();
                    }
                    case 3: {
                        return transaction.getResponseStatus();
                    }
                    case 4: {
                        if (transaction.getResponseHeader() != null) {
                            return mukF.eCYm(transaction.getResponseHeader());
                        }
                        return null;
                    }
                    case 5: {
                        if (transaction.getResponseHeader() != null) {
                            return this.formatter.uQqp(transaction.getResponseHeaderSize());
                        }
                        return null;
                    }
                    case 6: {
                        if (transaction.hasResponseBody()) {
                            return this.formatter.uQqp(transaction.getResponseSize());
                        }
                        return null;
                    }
                    case 7: {
                        if (transaction.getEndTime() != null && transaction.getStartTime() != null) {
                            return this.formatter.PRdh(transaction.getEndTime().getTime() - transaction.getStartTime().getTime());
                        }
                        return null;
                    }
                    case -1: {
                        return transaction;
                    }
                }
                return null;
            }
            if (n == this.size) {
                switch (n2) {
                    case 1: {
                        return "Total";
                    }
                    case 5: {
                        return this.formatter.uQqp(this.totalHeaderBytes);
                    }
                    case 6: {
                        return this.formatter.uQqp(this.totalBodyBytes);
                    }
                    case 7: {
                        return this.formatter.PRdh(this.totalTimes);
                    }
                }
                return null;
            }
            if (n == this.size + 1) {
                switch (n2) {
                    case 1: {
                        return "Grand Total";
                    }
                    case 6: {
                        return this.formatter.uQqp(this.totalHeaderBytes + this.totalBodyBytes);
                    }
                }
                return null;
            }
            if (n == this.size + 2) {
                switch (n2) {
                    case 1: {
                        return "Duration";
                    }
                    case 7: {
                        return this.formatter.PRdh(this.duration);
                    }
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.size + this.getFooterRows();
    }

    @Override
    public int getColumnCount() {
        return XdKP.length;
    }

    @Override
    public String getColumnName(int n) {
        return XdKP[n];
    }

    @Override
    public int getFooterRows() {
        return 3;
    }

    @Override
    public Class<?> getComparableColumnClass(int n) {
        switch (n) {
            case 1: {
                return String.class;
            }
            case 5: {
                return Integer.class;
            }
            case 6: 
            case 7: {
                return Long.class;
            }
        }
        return this.getColumnClass(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getComparableValueAt(int n, int n2) {
        List<Transaction> list = this.transactions;
        synchronized (list) {
            if (n < this.size) {
                Transaction transaction = this.transactions.get(n);
                switch (n2) {
                    case 1: {
                        return transaction.getFileName();
                    }
                    case 5: {
                        if (transaction.getResponseHeader() != null) {
                            return transaction.getResponseHeaderSize();
                        }
                        return null;
                    }
                    case 6: {
                        if (transaction.hasResponseBody()) {
                            return transaction.getResponseSize();
                        }
                        return null;
                    }
                    case 7: {
                        return bQkH.XdKP(transaction, null);
                    }
                }
                return this.getValueAt(n, n2);
            }
        }
        return null;
    }

    @Override
    public void modelChildAdded(ModelEvent modelEvent) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void modelChanged(ModelEvent modelEvent) {
        this.view(this.source);
    }

    @Override
    public void modelChildRemoved(ModelEvent modelEvent) {
        throw new UnsupportedOperationException();
    }
}

