/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.gui.transaction.general;

import com.xk72.charles.gui.lib.treetable.DefaultTreeTableNode;
import com.xk72.charles.lib.tfse;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.auth.x500.X500Principal;
import javax.swing.tree.MutableTreeNode;

public class uAtD {
    private static final String XdKP = "-";

    public static MutableTreeNode XdKP(Certificate certificate, tfse tfse2) {
        if (certificate instanceof X509Certificate) {
            X509Certificate x509Certificate = (X509Certificate)certificate;
            X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
            DefaultTreeTableNode defaultTreeTableNode = new DefaultTreeTableNode(uAtD.XdKP(x500Principal));
            defaultTreeTableNode.add(new DefaultTreeTableNode("Serial Number", uAtD.XdKP(x509Certificate.getSerialNumber().toByteArray())));
            defaultTreeTableNode.add(new DefaultTreeTableNode("Type", x509Certificate.getType() + " [v" + x509Certificate.getVersion() + "] (" + x509Certificate.getSigAlgName() + ")"));
            defaultTreeTableNode.add(uAtD.XdKP("Issued To", x500Principal));
            defaultTreeTableNode.add(uAtD.XdKP("Issued By", x509Certificate.getIssuerX500Principal()));
            if (x509Certificate.getNotBefore() != null) {
                defaultTreeTableNode.add(new DefaultTreeTableNode("Not Valid Before", tfse2.eCYm(x509Certificate.getNotBefore())));
            }
            if (x509Certificate.getNotAfter() != null) {
                defaultTreeTableNode.add(new DefaultTreeTableNode("Not Valid After", tfse2.eCYm(x509Certificate.getNotAfter())));
            }
            try {
                byte[] byArray = x509Certificate.getEncoded();
                DefaultTreeTableNode defaultTreeTableNode2 = new DefaultTreeTableNode("Fingerprints");
                defaultTreeTableNode2.add(new DefaultTreeTableNode("SHA-1", uAtD.XdKP(MessageDigest.getInstance("SHA-1").digest(byArray))));
                defaultTreeTableNode2.add(new DefaultTreeTableNode("SHA-256", uAtD.XdKP(MessageDigest.getInstance("SHA-256").digest(byArray))));
                defaultTreeTableNode.add(defaultTreeTableNode2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            defaultTreeTableNode.add(new DefaultTreeTableNode("Full Details", certificate.toString()));
            return defaultTreeTableNode;
        }
        DefaultTreeTableNode defaultTreeTableNode = new DefaultTreeTableNode(certificate.getType());
        defaultTreeTableNode.add(new DefaultTreeTableNode("Public Key Algorithm", certificate.getPublicKey().getAlgorithm()));
        defaultTreeTableNode.add(new DefaultTreeTableNode("Details", certificate.toString()));
        return defaultTreeTableNode;
    }

    public static String XdKP(X500Principal x500Principal) {
        try {
            LdapName ldapName = new LdapName(x500Principal.getName("RFC2253"));
            for (Rdn rdn : ldapName.getRdns()) {
                if (!"CN".equals(rdn.getType())) continue;
                return String.valueOf(rdn.getValue());
            }
            return String.valueOf(ldapName.getRdn(ldapName.size() - 1).getValue());
        }
        catch (InvalidNameException invalidNameException) {
            return x500Principal.toString();
        }
    }

    private static MutableTreeNode XdKP(String string, X500Principal x500Principal) {
        DefaultTreeTableNode defaultTreeTableNode = new DefaultTreeTableNode(string);
        try {
            LdapName ldapName = new LdapName(x500Principal.getName("RFC2253"));
            for (Rdn rdn : ldapName.getRdns()) {
                defaultTreeTableNode.insert(new DefaultTreeTableNode(rdn.getType(), rdn.getValue()), 0);
            }
        }
        catch (InvalidNameException invalidNameException) {
            defaultTreeTableNode.add(new DefaultTreeTableNode("Value", x500Principal.toString()));
        }
        return defaultTreeTableNode;
    }

    public static String XdKP(byte[] byArray) {
        if (byArray == null) {
            return XdKP;
        }
        if (byArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 3 - 1);
        stringBuilder.append(uAtD.XdKP(byArray[0] >> 4 & 0xF));
        stringBuilder.append(uAtD.XdKP(byArray[0] & 0xF));
        for (int i = 1; i < byArray.length; ++i) {
            stringBuilder.append(':');
            stringBuilder.append(uAtD.XdKP(byArray[i] >> 4 & 0xF));
            stringBuilder.append(uAtD.XdKP(byArray[i] & 0xF));
        }
        return stringBuilder.toString();
    }

    private static char XdKP(int n) {
        if (n < 10) {
            return (char)(48 + n);
        }
        return (char)(65 + (n - 10));
    }
}

