/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.gui.transaction.chart;

import com.xk72.charles.gui.transaction.chart.AbstractChartTableModel;
import com.xk72.charles.gui.transaction.chart.dqlb;
import com.xk72.charles.model.Transaction;
import com.xk72.charles.model.tGFF;
import java.util.Collections;
import java.util.Date;

public class ChartTimelineTableModel
extends AbstractChartTableModel {
    private Date minStart;
    private Date maxEnd;
    private boolean active;
    private final StringBuilder buf = new StringBuilder();
    private static final String[] XdKP = new String[]{"#", "Resource", "Timeline"};
    private static final Class<?>[] eCYm = new Class[]{Integer.class, Transaction.class, dqlb.class};

    public ChartTimelineTableModel() {
        super(XdKP, eCYm, 1);
        this.info = new dqlb(this);
    }

    @Override
    protected void update() {
        Collections.sort(this.transactions, new tGFF());
        int n = this.transactions.size();
        this.minStart = null;
        this.maxEnd = null;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            Transaction transaction = (Transaction)this.transactions.get(i);
            if (this.minStart == null || transaction.getStartTime().before(this.minStart)) {
                this.minStart = transaction.getStartTime();
            }
            if (transaction.getEndTime() == null) {
                bl = true;
                continue;
            }
            if (this.maxEnd != null && !transaction.getEndTime().after(this.maxEnd)) continue;
            this.maxEnd = transaction.getEndTime();
        }
        if (bl) {
            this.maxEnd = new Date();
            this.active = true;
        } else {
            this.active = false;
        }
        if (this.minStart == null) {
            this.minStart = this.maxEnd;
        }
    }

    @Override
    protected Object getFooterValueAt(int n, int n2) {
        switch (n2) {
            case 1: {
                return "Total Duration";
            }
            case 2: {
                if (this.minStart != null && this.maxEnd != null) {
                    this.buf.setLength(0);
                    this.formatter.XdKP(this.buf, this.maxEnd.getTime() - this.minStart.getTime());
                    if (this.active) {
                        this.buf.append("\u2026");
                    }
                    return this.buf.toString();
                }
                return null;
            }
        }
        return null;
    }

    public Date getMaxEnd() {
        return this.maxEnd;
    }

    public Date getMinStart() {
        return this.minStart;
    }
}

