/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.gui.transaction.chart;

import com.xk72.charles.gui.transaction.chart.AbstractChartTableModel;
import com.xk72.charles.gui.transaction.chart.ChartFlowTableModel$FlowType;
import com.xk72.charles.gui.transaction.chart.OEqP;
import com.xk72.charles.gui.transaction.chart.uAtD;
import com.xk72.charles.model.Flow;
import com.xk72.charles.model.Transaction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ChartFlowTableModel
extends AbstractChartTableModel {
    private static final int XdKP = 1024;
    private uAtD flowInfo = new uAtD(this);
    private boolean active;
    private long start;
    private long end;
    private ArrayList<OEqP> buckets = new ArrayList();
    private final StringBuilder buf = new StringBuilder();
    private static final String[] eCYm = new String[]{"#", "Resource", "Activity"};
    private static final Class<?>[] uQqp = new Class[]{Integer.class, Transaction.class, uAtD.class};

    public ChartFlowTableModel() {
        super(eCYm, uQqp, 1);
    }

    @Override
    protected void update() {
        int n = this.transactions.size();
        this.start = Long.MAX_VALUE;
        this.end = 0L;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            Transaction transaction = (Transaction)this.transactions.get(i);
            if (transaction.getEndTime() == null) {
                bl = true;
            } else if (transaction.getEndTime().getTime() > this.end) {
                this.end = transaction.getEndTime().getTime();
            }
            if (transaction.getStartTime().getTime() < this.start) {
                this.start = transaction.getStartTime().getTime();
            }
            int n2 = this.buckets.size();
            this.buckets.clear();
            this.XdKP(transaction, ChartFlowTableModel$FlowType.XdKP, transaction.getRequestFlow());
            this.XdKP(transaction, ChartFlowTableModel$FlowType.eCYm, transaction.getResponseFlow());
            if (n2 <= 1024 && this.buckets.size() <= 1024) continue;
            this.buckets.trimToSize();
        }
        if (bl) {
            this.active = true;
            this.end = System.currentTimeMillis();
        } else {
            this.active = false;
        }
        Collections.sort(this.buckets);
    }

    private void XdKP(Transaction transaction, ChartFlowTableModel$FlowType chartFlowTableModel$FlowType, Flow flow) {
        for (com.xk72.charles.model.uAtD uAtD2 : flow.getData()) {
            this.buckets.add(new OEqP(transaction, chartFlowTableModel$FlowType, uAtD2.XdKP, uAtD2.eCYm, uAtD2.uQqp));
        }
    }

    @Override
    public int getRowCount() {
        return this.buckets.size() + this.footerRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int n, int n2) {
        if (n < 0) {
            return null;
        }
        List list = this.transactions;
        synchronized (list) {
            if (n < this.buckets.size()) {
                switch (n2) {
                    case 0: {
                        return n + 1;
                    }
                    case 1: {
                        return this.buckets.get((int)n).XdKP;
                    }
                    case 2: {
                        this.flowInfo.XdKP(this.buckets.get(n));
                        return this.flowInfo;
                    }
                }
                return null;
            }
            return this.getFooterValueAt(n - this.transactions.size(), n2);
        }
    }

    @Override
    protected Object getFooterValueAt(int n, int n2) {
        switch (n2) {
            case 1: {
                return "Total Duration";
            }
            case 2: {
                if (this.transactions.size() > 0) {
                    this.buf.setLength(0);
                    this.formatter.XdKP(this.buf, this.end - this.start);
                    if (this.active) {
                        this.buf.append("\u2026");
                    }
                    return this.buf.toString();
                }
                return null;
            }
        }
        return null;
    }
}

