/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.gui.transaction.actions;

import com.xk72.charles.gui.lib.ExtendedJOptionPane;
import com.xk72.charles.gui.lib.SPPI;
import com.xk72.charles.gui.transaction.actions.mukF;
import com.xk72.charles.gui.transaction.actions.tfse;
import com.xk72.charles.lib.SkbX;
import com.xk72.charles.model.Transaction;
import com.xk72.proxy.websocket.WebSocketMessage;
import com.xk72.util.elVd;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.ProgressMonitor;

public class SaveWebSocketMessagesAction
extends AbstractAction {
    private final Transaction transaction;
    private static final int XdKP = 32;

    public SaveWebSocketMessagesAction(Transaction transaction) {
        super("Save WebSocket Messages\u2026");
        this.transaction = transaction;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.transaction != null) {
            JFileChooser jFileChooser = SPPI.XdKP();
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setDialogTitle("Select a directory to save into");
            jFileChooser.setApproveButtonText("Select");
            int n = jFileChooser.showOpenDialog((Component)actionEvent.getSource());
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                if (!file.isDirectory()) {
                    ExtendedJOptionPane.XdKP((Component)actionEvent.getSource(), "Invalid directory selected. Please select a directory to save into.", "Save All", 0);
                } else {
                    List<WebSocketMessage> list = this.transaction.getWebSocketMessages();
                    String string = SaveWebSocketMessagesAction.XdKP(this.transaction);
                    ArrayList<tfse> arrayList = new ArrayList<tfse>(list.size());
                    int n2 = 0;
                    int n3 = 0;
                    File file2 = null;
                    for (WebSocketMessage webSocketMessage : list) {
                        String string2;
                        if (webSocketMessage.getType().isControl()) continue;
                        switch (webSocketMessage.getSource()) {
                            case XdKP: {
                                string2 = this.XdKP(string, ++n3, webSocketMessage);
                                break;
                            }
                            case eCYm: {
                                string2 = this.XdKP(string, ++n3, webSocketMessage);
                                break;
                            }
                            default: {
                                string2 = null;
                            }
                        }
                        File file3 = new File(file, string2);
                        if (file3.exists()) {
                            ++n2;
                            file2 = file3;
                        }
                        arrayList.add(new tfse(file3, webSocketMessage));
                    }
                    if (n2 > 0 && (n = n2 == 1 ? ExtendedJOptionPane.XdKP((Component)actionEvent.getSource(), "A file named \"" + file2.getName() + "\" already exists.", "Replace Existing File", 2, 2, null, new String[]{"Replace", "Cancel"}, "Replace") : ExtendedJOptionPane.XdKP((Component)actionEvent.getSource(), n2 + " files already exist and will be replaced.", "Replace Existing Files", 2, 2, null, new String[]{"Replace All", "Cancel"}, "Replace All")) != 0 && n == 1) {
                        return;
                    }
                    if (arrayList.isEmpty()) {
                        ExtendedJOptionPane.XdKP((Component)actionEvent.getSource(), "No messages were found to save.", "Save All", 0);
                    } else {
                        ProgressMonitor progressMonitor = new ProgressMonitor((Component)actionEvent.getSource(), "Saving files\u2026", "", 0, arrayList.size());
                        elVd.XdKP(new mukF(this, arrayList, progressMonitor, actionEvent));
                    }
                }
            }
        }
    }

    private static String XdKP(Transaction transaction) {
        int n;
        String string = transaction.getPath();
        String string2 = string.substring((n = string.lastIndexOf(47)) + 1);
        if (string2.isEmpty()) {
            return SkbX.XdKP(transaction.getHost(), false);
        }
        if (string2.length() > 32) {
            return SkbX.XdKP(string2.substring(0, 32), false);
        }
        return SkbX.XdKP(string2, false);
    }

    private String XdKP(String string, int n, WebSocketMessage webSocketMessage) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append('_');
        stringBuffer.append(String.format("%06d", n));
        switch (webSocketMessage.getSource()) {
            case XdKP: {
                stringBuffer.append("_client");
                break;
            }
            case eCYm: {
                stringBuffer.append("_server");
            }
        }
        switch (webSocketMessage.getType()) {
            case XdKP: 
            case uQqp: {
                stringBuffer.append(".txt");
                break;
            }
            default: {
                stringBuffer.append(".bin");
            }
        }
        return stringBuffer.toString();
    }
}

