/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.gui.settings;

import com.xk72.charles.CharlesContext;
import com.xk72.charles.config.LocationPatternConfiguration;
import com.xk72.charles.config.ProxyConfiguration;
import com.xk72.charles.gui.lib.EnableAwareJPanel;
import com.xk72.charles.gui.lib.FormUtils;
import com.xk72.charles.gui.lib.LocationsTableHelper;
import com.xk72.charles.gui.lib.LocationsTableHelper$Mode;
import com.xk72.charles.gui.settings.SettingsPanel;
import com.xk72.charles.tools.gui.OEqP;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;

class SSLProxyingPanel
extends SettingsPanel {
    private final OEqP modePanel;
    private final LocationsTableHelper locations;
    private final LocationsTableHelper exclude;

    public SSLProxyingPanel() {
        super(CharlesContext.getInstance().getBundle().getString("settings.proxy.ssl.name"));
        this.setHelp(this.ctx.getBundle().getString("settings.proxy.ssl.help"));
        ProxyConfiguration proxyConfiguration = this.ctx.getConfiguration().getProxyConfiguration();
        this.modePanel = new OEqP("SSL Proxying", 1);
        this.locations = new LocationsTableHelper(proxyConfiguration.getSSLLocations().getLocationPatterns(), LocationsTableHelper$Mode.uQqp);
        this.exclude = new LocationsTableHelper(proxyConfiguration.getSSLExcludeLocations().getLocationPatterns(), LocationsTableHelper$Mode.uQqp);
        EnableAwareJPanel enableAwareJPanel = new EnableAwareJPanel((LayoutManager)new MigLayout("wrap,fill,ins 0", "[][]", "[][fill,grow]"));
        enableAwareJPanel.add(new JLabel("Include"));
        enableAwareJPanel.add(new JLabel("Exclude"));
        this.locations.XdKP(enableAwareJPanel);
        this.exclude.XdKP(enableAwareJPanel);
        this.modePanel.XdKP(this.locations);
        this.modePanel.XdKP(this.exclude);
        this.modePanel.XdKP(enableAwareJPanel, false);
        this.configure(proxyConfiguration);
        this.add(FormUtils.uQqp(this.ctx.getBundle().getString("settings.proxy.ssl.blurb")));
        this.add(this.modePanel.XdKP());
        this.add((Component)enableAwareJPanel, "grow, push");
    }

    void configure(ProxyConfiguration proxyConfiguration) {
        this.modePanel.XdKP(proxyConfiguration.isDecryptSSL());
    }

    @Override
    public boolean save() {
        ProxyConfiguration proxyConfiguration = this.ctx.getConfiguration().getProxyConfiguration();
        proxyConfiguration.setDecryptSSL(this.modePanel.eCYm());
        proxyConfiguration.setSSLLocations(new LocationPatternConfiguration(this.locations.Vvaz().getRows()));
        proxyConfiguration.setSSLExcludeLocations(new LocationPatternConfiguration(this.exclude.Vvaz().getRows()));
        CharlesContext.getInstance().getProxyManager().ERKX();
        return true;
    }

    public void updateForm() {
    }
}

