/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.gui.settings;

import com.xk72.charles.CharlesContext;
import com.xk72.charles.config.ProxyConfiguration;
import com.xk72.charles.gui.lib.EnableAwareJPanel;
import com.xk72.charles.gui.lib.FormUtils;
import com.xk72.charles.gui.settings.FvmR;
import com.xk72.charles.gui.settings.ImportCertificateHelper;
import com.xk72.charles.gui.settings.RootSSLCertificateSettingsPanel$1;
import com.xk72.charles.gui.settings.RootSSLCertificateSettingsPanel$2;
import com.xk72.charles.gui.settings.RootSSLCertificateSettingsPanel$3;
import com.xk72.charles.gui.settings.SettingsPanel;
import com.xk72.charles.ssl.CertificateConfiguration;
import com.xk72.charles.ssl.SSLCertificateStore;
import com.xk72.charles.ssl.tfse;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

class RootSSLCertificateSettingsPanel
extends SettingsPanel {
    private static final String XdKP = "Using automatically generated root certificate";
    private final JLabel certificateName;
    private final JButton removeButton;
    private CertificateConfiguration rootCertificate;

    public RootSSLCertificateSettingsPanel() {
        super(CharlesContext.getInstance().getBundle().getString("settings.serverSSLCertificates.name"));
        this.setHelp(this.ctx.getBundle().getString("settings.serverSSLCertificates.help"));
        tfse tfse2 = this.ctx.getSSLManager();
        SSLCertificateStore sSLCertificateStore = tfse2.eCYm();
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("wrap, ins 0, fillx", "[fill]"));
        jPanel.add(FormUtils.uQqp(this.ctx.getBundle().getString("settings.serverSSLCertificates.blurb")));
        EnableAwareJPanel enableAwareJPanel = new EnableAwareJPanel((LayoutManager)new MigLayout("wrap,fill,ins 0,hidemode 2", "[fill,grow][][][]"));
        jPanel.add(enableAwareJPanel);
        this.certificateName = new JLabel();
        enableAwareJPanel.add((Component)this.certificateName, "wmin 10");
        enableAwareJPanel.add(new JButton(new RootSSLCertificateSettingsPanel$1(this, "Import PEM", sSLCertificateStore)));
        enableAwareJPanel.add(new JButton(new RootSSLCertificateSettingsPanel$2(this, "Import P12", sSLCertificateStore)));
        this.removeButton = new JButton(new RootSSLCertificateSettingsPanel$3(this, "Remove"));
        enableAwareJPanel.add(this.removeButton);
        this.add((Component)ImportCertificateHelper.XdKP(sSLCertificateStore, jPanel), "grow,push");
        ProxyConfiguration proxyConfiguration = this.ctx.getConfiguration().getProxyConfiguration();
        this.XdKP(proxyConfiguration.getSSLRootCertificate());
        jPanel.addComponentListener(new FvmR(this, proxyConfiguration));
    }

    private void XdKP(CertificateConfiguration certificateConfiguration) {
        this.rootCertificate = certificateConfiguration;
        if (this.rootCertificate != null) {
            this.certificateName.setText(this.rootCertificate.getName());
            this.removeButton.setVisible(true);
        } else {
            this.certificateName.setText(XdKP);
            this.removeButton.setVisible(false);
        }
    }

    @Override
    public boolean save() {
        ProxyConfiguration proxyConfiguration = this.ctx.getConfiguration().getProxyConfiguration();
        CertificateConfiguration certificateConfiguration = proxyConfiguration.getSSLRootCertificate();
        if (this.rootCertificate != certificateConfiguration) {
            if (certificateConfiguration != null) {
                if (certificateConfiguration.getFileAlias() != null) {
                    this.ctx.getFileStore().eCYm(certificateConfiguration.getFileAlias());
                }
                if (certificateConfiguration.getStoreAlias() != null) {
                    try {
                        this.ctx.getSSLManager().eCYm().XdKP(certificateConfiguration.getStoreAlias());
                    }
                    catch (IOException | GeneralSecurityException exception) {
                        // empty catch block
                    }
                }
            }
            proxyConfiguration.setSSLRootCertificate(this.rootCertificate);
        }
        return true;
    }
}

