/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.gui.settings;

import com.xk72.charles.config.CategoryConfiguration$CategoryCondition;
import com.xk72.charles.config.CategoryConfiguration$ConditionType;
import com.xk72.charles.gui.lib.AbstractSettingsFormPanel;
import com.xk72.charles.gui.lib.EnableAwareJLabel;
import com.xk72.charles.gui.lib.FormUtils;
import com.xk72.charles.gui.lib.UIUtils;
import com.xk72.charles.gui.settings.CHDR;
import com.xk72.charles.gui.settings.MfoV;
import com.xk72.charles.gui.settings.mYlx;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

class HighlightSettingsPanel$ConditionPanel
extends AbstractSettingsFormPanel<CategoryConfiguration$CategoryCondition> {
    private CategoryConfiguration$CategoryCondition condition;
    private final JComboBox<CategoryConfiguration$ConditionType> type = new JComboBox<CategoryConfiguration$ConditionType>(CategoryConfiguration$ConditionType.values());
    private final JTextField name = new JTextField();
    private final JTextField value = new JTextField();
    private final JCheckBox regex = new JCheckBox("Regex");
    private final JCheckBox caseSensitive = new JCheckBox("Case sensitive");
    private final JCheckBox matchWholeValue = new JCheckBox("Match whole value");
    private final JRadioButton matches = new JRadioButton("Matches");
    private final JRadioButton doesNotMatch = new JRadioButton("Does not match");
    private final JTextArea matchHelp;

    public HighlightSettingsPanel$ConditionPanel(Component component) {
        super("Edit Condition", component);
        this.setPreferredSize(new Dimension(400, 0));
        this.setLayout(FormUtils.qvCh("ins " + UIUtils.XdKP() + ",hidemode 3"));
        this.setHelp(this.ctx.getBundle().getString("settings.highlight.editor.help"));
        this.matchHelp = FormUtils.Idso("");
        this.matchHelp.setForeground(Color.red);
        this.matchHelp.setVisible(false);
        this.value.getDocument().addDocumentListener(new MfoV(this));
        this.regex.addItemListener(new CHDR(this));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.matches);
        buttonGroup.add(this.doesNotMatch);
        this.matches.setSelected(true);
        this.add((Component)new JLabel("Type:"), "label");
        this.add(this.type);
        this.add((Component)new EnableAwareJLabel("Name:", this.name), "label");
        this.add(this.name);
        this.add((Component)this.matches, "skip 1,split 2,span");
        this.add(this.doesNotMatch);
        this.add((Component)new JLabel("Value:"), "label");
        this.add(this.value);
        this.add((Component)this.regex, "skip 1,split 3,span");
        this.add(this.matchWholeValue);
        this.add(this.caseSensitive);
        this.add((Component)this.matchHelp, "left,span,grow");
        String string = this.ctx.getBundle().getString("settings.highlight.editor.blurb");
        if (string != null && string.length() > 0) {
            JPanel jPanel = new JPanel(FormUtils.qvCh());
            jPanel.add((Component)FormUtils.PRdh(string), "width 400lp!, left");
            this.add(jPanel);
        }
        this.type.addItemListener(new mYlx(this));
        this.type.setSelectedItem((Object)CategoryConfiguration$ConditionType.eCYm);
    }

    private void XdKP() {
        if (this.regex.isSelected()) {
            try {
                Pattern.compile(this.value.getText());
                this.XdKP(null);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                this.XdKP(patternSyntaxException.getMessage());
            }
        } else {
            this.XdKP(null);
        }
    }

    private void XdKP(String string) {
        Dialog dialog;
        boolean bl = this.matchHelp.isVisible();
        boolean bl2 = string != null;
        this.matchHelp.setText(string);
        this.matchHelp.setVisible(bl2);
        if ((bl || bl2) && (dialog = (Dialog)SwingUtilities.getAncestorOfClass(Dialog.class, this.matchHelp)) != null) {
            Dimension dimension = dialog.getPreferredSize();
            dimension.width = Math.max(dimension.width, dialog.getWidth());
            dialog.setPreferredSize(dimension);
            dialog.pack();
            dialog.setPreferredSize(null);
        }
    }

    @Override
    public void setValue(CategoryConfiguration$CategoryCondition categoryConfiguration$CategoryCondition) {
        this.condition = categoryConfiguration$CategoryCondition;
        this.type.setSelectedItem((Object)(categoryConfiguration$CategoryCondition.getType() == null ? CategoryConfiguration$ConditionType.eCYm : categoryConfiguration$CategoryCondition.getType()));
        this.name.setText(categoryConfiguration$CategoryCondition.getName());
        this.value.setText(categoryConfiguration$CategoryCondition.getValue());
        this.regex.setSelected(categoryConfiguration$CategoryCondition.isRegex());
        this.caseSensitive.setSelected(categoryConfiguration$CategoryCondition.isCaseSensitive());
        this.matchWholeValue.setSelected(categoryConfiguration$CategoryCondition.isMatchWholeValue());
        this.doesNotMatch.setSelected(categoryConfiguration$CategoryCondition.isNegate());
    }

    @Override
    public CategoryConfiguration$CategoryCondition getValue() {
        return this.condition;
    }

    @Override
    public boolean preSave() {
        return super.preSave();
    }

    @Override
    public boolean save() {
        this.condition.setType((CategoryConfiguration$ConditionType)((Object)this.type.getSelectedItem()));
        this.condition.setName(this.name.getText());
        this.condition.setValue(this.value.getText());
        this.condition.setRegex(this.regex.isSelected());
        this.condition.setCaseSensitive(this.caseSensitive.isSelected());
        this.condition.setMatchWholeValue(this.matchWholeValue.isSelected());
        this.condition.setNegate(this.doesNotMatch.isSelected());
        return true;
    }
}

