/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.gui.settings;

import com.xk72.charles.config.ExternalDNSResolverConfiguration;
import com.xk72.charles.gui.lib.EnableAwareJLabel;
import com.xk72.charles.gui.lib.LocationsTableHelper;
import com.xk72.charles.gui.lib.LocationsTableHelper$Mode;
import com.xk72.charles.gui.settings.AbstractImportExportSettingsPanel;
import com.xk72.charles.gui.settings.SettingsException;
import com.xk72.charles.tools.gui.OEqP;
import com.xk72.net.elVd;
import com.xk72.util.TUqP;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JTextField;

public class ExternalDNSResolverSettingsPanel
extends AbstractImportExportSettingsPanel<ExternalDNSResolverConfiguration> {
    private final OEqP mode;
    private final JTextField externalResolverAddress = new JTextField();
    private final LocationsTableHelper helper;

    public ExternalDNSResolverSettingsPanel() {
        super("External DNS Resolver");
        this.mode = new OEqP(this.getTitle(), 2, "hosts");
        this.add(this.mode.XdKP());
        this.add((Component)new EnableAwareJLabel("External Resolver Address:", this.externalResolverAddress), "label, grow 0, split 2");
        this.add(this.externalResolverAddress);
        this.mode.XdKP(this.externalResolverAddress, false);
        this.helper = new LocationsTableHelper(new ArrayList<elVd>(), LocationsTableHelper$Mode.AhDU);
        this.helper.XdKP(100);
        this.mode.XdKP(this.helper);
        this.helper.XdKP(this);
    }

    @Override
    protected ExternalDNSResolverConfiguration getConfiguration() {
        return this.ctx.getConfiguration().getExternalDNSResolverConfiguration();
    }

    @Override
    protected ExternalDNSResolverConfiguration newConfiguration() {
        return new ExternalDNSResolverConfiguration();
    }

    @Override
    protected void getPanelConfiguration(ExternalDNSResolverConfiguration externalDNSResolverConfiguration) {
        externalDNSResolverConfiguration.setEnabled(this.mode.eCYm());
        externalDNSResolverConfiguration.setSelectedLocations(this.mode.uQqp());
        externalDNSResolverConfiguration.setExternalResolverAddress(this.externalResolverAddress.getText());
        externalDNSResolverConfiguration.getLocations().setLocationPatterns(this.helper.Vvaz().getRows());
    }

    @Override
    protected void setPanelConfiguration(ExternalDNSResolverConfiguration externalDNSResolverConfiguration) {
        this.mode.XdKP(externalDNSResolverConfiguration.isEnabled());
        this.mode.eCYm(externalDNSResolverConfiguration.isSelectedLocations());
        this.externalResolverAddress.setText(externalDNSResolverConfiguration.getExternalResolverAddress());
        ArrayList<elVd> arrayList = new ArrayList<elVd>();
        for (elVd elVd2 : externalDNSResolverConfiguration.getLocations().getLocationPatterns()) {
            arrayList.add(elVd2.clone());
        }
        this.helper.Vvaz().setRows(arrayList);
    }

    @Override
    protected void configurationUpdated() {
        this.ctx.getProxyManager().CsNq();
    }

    @Override
    public boolean preSave() {
        String string;
        if (!super.preSave()) {
            return false;
        }
        if (this.mode.eCYm() && TUqP.QNPA(string = this.externalResolverAddress.getText())) {
            throw new SettingsException("The External Resolver Address must be specified in order to enable the External DNS Resolver");
        }
        return true;
    }
}

