/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.gui.session.popups;

import com.xk72.charles.CharlesContext;
import com.xk72.charles.config.LocationPatternConfiguration;
import com.xk72.charles.gui.find.AdvancedFindDialog;
import com.xk72.charles.gui.lib.actions.CollapsePathAction;
import com.xk72.charles.gui.lib.actions.ExpandPathAction;
import com.xk72.charles.gui.session.actions.ClearAction;
import com.xk72.charles.gui.session.actions.ClearOthersAction;
import com.xk72.charles.gui.session.actions.ClearOthersSequenceAction;
import com.xk72.charles.gui.session.popups.OEqP;
import com.xk72.charles.gui.session.popups.VOPs;
import com.xk72.charles.gui.session.popups.XaRp;
import com.xk72.charles.gui.session.popups.eaPA;
import com.xk72.charles.gui.session.popups.elVd;
import com.xk72.charles.gui.session.popups.uAtD;
import com.xk72.charles.gui.session.tGFF;
import com.xk72.charles.gui.session.trees.MfoV;
import com.xk72.charles.gui.session.trees.bAUT;
import com.xk72.charles.gui.session.trees.tfse;
import com.xk72.charles.model.Host;
import com.xk72.charles.model.ModelNode;
import com.xk72.charles.model.ModelNodeComparator;
import com.xk72.charles.ssl.SkbX;
import com.xk72.charles.tools.LocationSelectingTool;
import com.xk72.charles.tools.LocationUsingTool;
import com.xk72.charles.tools.lib.CharlesTool;
import com.xk72.net.Location;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public abstract class AbstractModelNodePopupMenu
extends JPopupMenu {
    protected ModelNode[] nodes;
    protected com.xk72.charles.gui.navigator.elVd<?> navigator;
    private final tGFF focusManager;
    protected final AdvancedFindDialog findDialog;

    public AbstractModelNodePopupMenu(ModelNode modelNode, com.xk72.charles.gui.navigator.elVd<?> elVd2, tGFF tGFF2, AdvancedFindDialog advancedFindDialog) {
        this(new ModelNode[]{modelNode}, elVd2, tGFF2, advancedFindDialog);
    }

    public AbstractModelNodePopupMenu(ModelNode[] modelNodeArray, com.xk72.charles.gui.navigator.elVd<?> elVd2, tGFF tGFF2, AdvancedFindDialog advancedFindDialog) {
        this.nodes = modelNodeArray;
        this.navigator = elVd2;
        this.focusManager = tGFF2;
        this.findDialog = advancedFindDialog;
    }

    public void show(MouseEvent mouseEvent) {
        Component component;
        if (this.getComponentCount() != 0) {
            this.removeAll();
        }
        this.prepare(mouseEvent);
        while (this.getComponentCount() > 0 && (component = this.getComponent(this.getComponentCount() - 1)) instanceof JPopupMenu.Separator) {
            this.remove(component);
        }
        if (this.getComponentCount() != 0) {
            this.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    protected abstract void prepare(MouseEvent var1);

    protected boolean addFocus() {
        Host[] hostArray;
        if (this.focusManager != null && (hostArray = this.XdKP()) != null) {
            boolean bl = true;
            for (Host host : hostArray) {
                bl = bl && this.focusManager.XdKP(host);
            }
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Focus");
            jCheckBoxMenuItem.setSelected(bl);
            jCheckBoxMenuItem.addItemListener(new elVd(this, hostArray));
            this.add(jCheckBoxMenuItem);
            return true;
        }
        return false;
    }

    private Host[] XdKP() {
        HashSet<Host> hashSet = new HashSet<Host>();
        for (ModelNode modelNode : this.nodes) {
            Host host = this.XdKP(modelNode);
            if (host == null) continue;
            hashSet.add(host);
        }
        return hashSet.isEmpty() ? null : hashSet.toArray(new Host[hashSet.size()]);
    }

    private Host XdKP(ModelNode modelNode) {
        if (modelNode == null) {
            return null;
        }
        if (modelNode instanceof Host) {
            return (Host)modelNode;
        }
        return this.XdKP(modelNode.getParent());
    }

    protected boolean addReorder() {
        if (this.navigator != null && this.navigator.XdKP() instanceof tfse) {
            TreePath[] treePathArray;
            JTree jTree = (JTree)this.navigator.uQqp();
            boolean bl = false;
            ModelNode modelNode = this.nodes.length != 0 ? this.nodes[0].getParent() : null;
            for (int i = 1; i < this.nodes.length; ++i) {
                if (this.nodes[i].getParent() == modelNode) continue;
                modelNode = null;
                break;
            }
            if (modelNode != null) {
                ModelNode modelNode2 = modelNode;
                tfse tfse2 = (tfse)this.navigator.XdKP();
                Comparator<ModelNode> comparator = tfse2.XdKP(modelNode2);
                JMenu jMenu = new JMenu("Sort By");
                for (ModelNodeComparator modelNodeComparator : ModelNodeComparator.values()) {
                    JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(modelNodeComparator.getName());
                    jCheckBoxMenuItem.setSelected(comparator == modelNodeComparator.getComparator());
                    jCheckBoxMenuItem.addItemListener(new eaPA(this, tfse2, modelNode2, modelNodeComparator));
                    jMenu.add(jCheckBoxMenuItem);
                }
                this.add(jMenu);
                bl = true;
            }
            if ((treePathArray = jTree.getSelectionPaths()) != null && ExpandPathAction.XdKP(jTree, treePathArray)) {
                this.add(new ExpandPathAction(jTree, treePathArray));
                this.add(new CollapsePathAction(jTree, treePathArray));
                bl = true;
            }
            return bl;
        }
        return false;
    }

    protected void addIgnore() {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Ignore");
        jCheckBoxMenuItem.setSelected(this.isIgnored());
        jCheckBoxMenuItem.addItemListener(new OEqP(this));
        this.add(jCheckBoxMenuItem);
    }

    protected void addClear() {
        this.add(new ClearAction(this.nodes));
    }

    protected void addClearOthers() {
        if (this.navigator instanceof com.xk72.charles.gui.session.tables.elVd || this.navigator instanceof bAUT) {
            this.add(new ClearOthersSequenceAction(this.nodes));
        } else if (this.navigator instanceof MfoV) {
            this.add(new ClearOthersAction(this.nodes));
        }
    }

    protected abstract Location toLocation();

    protected Collection<Location> toLocations() {
        Location location = this.toLocation();
        if (location != null) {
            return Collections.singleton(location);
        }
        return Collections.emptyList();
    }

    protected boolean isIgnored() {
        LocationPatternConfiguration locationPatternConfiguration = CharlesContext.getInstance().getConfiguration().getRecordingConfiguration().getIgnoreHosts();
        for (Location location : this.getIgnoreKey()) {
            if (!com.xk72.net.OEqP.XdKP(location, locationPatternConfiguration.getLocationPatterns())) continue;
            return true;
        }
        return false;
    }

    protected Collection<Location> getIgnoreKey() {
        return this.toLocations();
    }

    protected boolean isSelectedLocation(LocationSelectingTool locationSelectingTool) {
        return locationSelectingTool.isSelectedLocation(this.toLocation());
    }

    protected void selectLocation(LocationSelectingTool locationSelectingTool) {
        locationSelectingTool.selectLocation(this.toLocation());
    }

    protected void deselectLocation(LocationSelectingTool locationSelectingTool) {
        locationSelectingTool.deselectLocation(this.toLocation());
    }

    protected void useLocation(LocationUsingTool locationUsingTool) {
        locationUsingTool.useLocation(this.toLocation());
    }

    protected boolean isUsingLocation(LocationUsingTool locationUsingTool) {
        return locationUsingTool.isUsingLocation(this.toLocation());
    }

    protected void addSelectingTools() {
        List<CharlesTool> list = CharlesContext.getInstance().getAllTools();
        for (CharlesTool charlesTool : list) {
            if (!(charlesTool instanceof LocationSelectingTool)) continue;
            LocationSelectingTool locationSelectingTool = (LocationSelectingTool)((Object)charlesTool);
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(locationSelectingTool.getName());
            jCheckBoxMenuItem.setSelected(this.isSelectedLocation(locationSelectingTool));
            jCheckBoxMenuItem.addItemListener(new uAtD(this, locationSelectingTool));
            this.add(jCheckBoxMenuItem);
        }
    }

    protected void addSSLProxyingSelector() {
        if (this.nodes.length > 0) {
            SkbX skbX = new SkbX();
            Location location = this.toLocation();
            boolean bl = skbX.isSelectedLocation(location);
            JMenuItem jMenuItem = new JMenuItem(bl ? "SSL Proxying: Enabled" : "SSL Proxying: Disabled");
            jMenuItem.setEnabled(false);
            this.add(jMenuItem);
            JMenuItem jMenuItem2 = new JMenuItem(bl ? "Disable SSL Proxying" : "Enable SSL Proxying");
            jMenuItem2.addActionListener(new XaRp(this, skbX, location, jMenuItem2, jMenuItem));
            this.add(jMenuItem2);
            jMenuItem2.setEnabled(CharlesContext.getInstance().getConfiguration().getProxyConfiguration().isDecryptSSL());
        }
    }

    protected void addUsingTools() {
        List<CharlesTool> list = CharlesContext.getInstance().getAllTools();
        for (CharlesTool charlesTool : list) {
            if (!(charlesTool instanceof LocationUsingTool)) continue;
            this.addLocationUsingTool((LocationUsingTool)((Object)charlesTool));
        }
    }

    protected void addLocationUsingTool(LocationUsingTool locationUsingTool) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(locationUsingTool.getName() + "\u2026");
        jCheckBoxMenuItem.setSelected(this.isUsingLocation(locationUsingTool));
        jCheckBoxMenuItem.addItemListener(new VOPs(this, locationUsingTool));
        this.add(jCheckBoxMenuItem);
    }
}

