/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.gui.navigator;

import com.xk72.charles.gui.navigator.MfoV;
import com.xk72.charles.gui.navigator.elVd;
import com.xk72.charles.model.ModelNode;
import com.xk72.charles.model.Session;
import com.xk72.charles.model.Transaction;
import com.xk72.charles.model.Vlpk;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public class NavigatorTransferHandler
extends TransferHandler {
    private static final Logger XdKP = Logger.getLogger("com.xk72.charles.gui.navigator.NavigatorTransferHandler");
    private static final DataFlavor eCYm = new DataFlavor(Transaction.class, "Transaction");
    private final TransferHandler delegate;
    private final Session session;

    public NavigatorTransferHandler(TransferHandler transferHandler, Session session) {
        this.delegate = transferHandler;
        this.session = session;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport transferSupport) {
        if (transferSupport.isDataFlavorSupported(eCYm)) {
            return true;
        }
        return this.delegate != null && this.delegate.canImport(transferSupport);
    }

    @Override
    protected Transferable createTransferable(JComponent jComponent) {
        Transferable transferable;
        Object object;
        if (this.delegate != null && (this.delegate.getSourceActions(jComponent) & 1) != 0) {
            object = new Clipboard("dummy");
            this.delegate.exportToClipboard(jComponent, (Clipboard)object, 1);
            transferable = ((Clipboard)object).getContents(null);
        } else {
            transferable = null;
        }
        object = this.XdKP(jComponent);
        return new MfoV(this, transferable, (List)object);
    }

    @Override
    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        if (n == 2) {
            try {
                List list = (List)transferable.getTransferData(eCYm);
                for (Transaction transaction : list) {
                    transaction.remove();
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                XdKP.log(Level.WARNING, "Error exporting transaction data", unsupportedFlavorException);
            }
            catch (IOException iOException) {
                XdKP.log(Level.WARNING, "Error exporting transaction data", iOException);
            }
        }
    }

    private List<Transaction> XdKP(JComponent jComponent) {
        ModelNode[] modelNodeArray;
        elVd elVd2 = elVd.XdKP(jComponent);
        if (elVd2 != null && (modelNodeArray = (ModelNode[])elVd2.AhDU()) != null) {
            Vlpk vlpk = new Vlpk();
            vlpk.XdKP(modelNodeArray);
            List<Transaction> list = vlpk.XdKP();
            Iterator<Transaction> iterator = list.iterator();
            while (iterator.hasNext()) {
                if (this.XdKP(iterator.next())) continue;
                iterator.remove();
            }
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        return 3;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport transferSupport) {
        try {
            if (transferSupport.isDataFlavorSupported(eCYm)) {
                List list = (List)transferSupport.getTransferable().getTransferData(eCYm);
                for (Transaction transaction : list) {
                    Transaction transaction2 = (Transaction)transaction.clone();
                    this.session.addTransaction(transaction2);
                }
                return true;
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            XdKP.log(Level.WARNING, "Error importing transaction data", unsupportedFlavorException);
        }
        catch (IOException iOException) {
            XdKP.log(Level.WARNING, "Error importing transaction data", iOException);
        }
        return false;
    }

    private boolean XdKP(Transaction transaction) {
        switch (transaction.getStatus()) {
            case ERKX: 
            case gMxR: 
            case CsNq: {
                return true;
            }
        }
        return false;
    }
}

