/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.gui.menus;

import com.xk72.charles.CharlesContext;
import com.xk72.charles.gui.CharlesFrame;
import com.xk72.charles.gui.lib.SPPI;
import com.xk72.charles.gui.menus.ExportSSLCACertificateAction$MySettingsPanel;
import com.xk72.charles.gui.menus.elVd;
import com.xk72.charles.gui.settings.SettingsDialog;
import com.xk72.charles.gui.settings.SettingsPanel;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import org.bouncycastle.operator.OperatorCreationException;

public class ExportSSLCACertificateAction
extends AbstractAction {
    public ExportSSLCACertificateAction() {
        super("Export Charles Root Certificate and Private Key\u2026");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ExportSSLCACertificateAction$MySettingsPanel exportSSLCACertificateAction$MySettingsPanel = new ExportSSLCACertificateAction$MySettingsPanel(this);
        SettingsDialog settingsDialog = new SettingsDialog((Frame)CharlesFrame.XdKP(), (SettingsPanel)exportSSLCACertificateAction$MySettingsPanel);
        settingsDialog.setModal(true);
        settingsDialog.setSaveConfig(false);
        int n = settingsDialog.showAndWait();
        if (n != 2) {
            return;
        }
        char[] cArray = exportSSLCACertificateAction$MySettingsPanel.passwordField.getPassword();
        if (cArray.length == 0) {
            CharlesContext.getInstance().error("You cannot export the Root Certificate and key with an empty password.");
            return;
        }
        JFileChooser jFileChooser = SPPI.XdKP();
        com.xk72.charles.lib.elVd elVd2 = new com.xk72.charles.lib.elVd("p12", "PKCS#12 key file");
        jFileChooser.addChoosableFileFilter(elVd2);
        jFileChooser.setFileFilter(elVd2);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setSelectedFile(new File(jFileChooser.getCurrentDirectory(), "charles-ssl-proxying.p12"));
        SPPI.XdKP(jFileChooser, new elVd(this, elVd2, cArray));
    }

    protected void savePKCS12(char[] cArray, File file) {
        try {
            if (!CharlesContext.getInstance().getSSLManager().XdKP(cArray, file)) {
                throw new IOException("Couldn\u2019t find the Charles Root Certificate.");
            }
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            throw new IOException("Failed to extract the Charles Root Certificate details.");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException("Failed to extract the Charles Root Certificate details.");
        }
        catch (CertificateException certificateException) {
            throw new IOException("Failed to extract the Charles Root Certificate details.");
        }
        catch (KeyStoreException keyStoreException) {
            throw new IOException("Failed to extract the Charles Root Certificate details.");
        }
        catch (OperatorCreationException operatorCreationException) {
            throw new IOException("Failed to extract the Charles Root Certificate details.");
        }
    }
}

