/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.gui.lib;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class MultiImagePanel
extends JPanel {
    private static final int XdKP = 10;
    private List<? extends Image> images;
    private final Font font;

    public MultiImagePanel() {
        this.setBackground(Color.white);
        this.font = UIManager.getDefaults().getFont("Label.font");
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.images != null) {
            graphics.setFont(this.font);
            boolean bl = false;
            int n = 0;
            int n2 = this.font.getSize() + 10;
            for (Image image : this.images) {
                int n3 = image.getWidth(null);
                int n4 = image.getHeight(null);
                if (n3 >= 0 && n4 >= 0) {
                    graphics.drawString(n3 + " x " + n4, 0, n + this.font.getSize() + 3);
                }
                graphics.drawImage(image, 0, n + n2, this);
                n += n4 + n2 + 10;
            }
        }
    }

    public boolean hasImages() {
        return this.images != null && !this.images.isEmpty();
    }

    public void setImages(List<? extends Image> list) {
        this.images = list;
        this.repaint();
    }

    public void clearImages() {
        this.images = null;
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.images != null) {
            int n = 0;
            int n2 = 0;
            for (Image image : this.images) {
                n2 += image.getHeight(null) + this.font.getSize() + 10 + 10;
                n = Math.max(n, image.getWidth(null));
            }
            return new Dimension(n, n2);
        }
        return super.getPreferredSize();
    }
}

