/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.export;

import com.xk72.charles.export.MfoV;
import com.xk72.charles.export.eaPA;
import com.xk72.charles.lib.mukF;
import com.xk72.charles.model.Session;
import com.xk72.charles.model.Transaction;
import com.xk72.lib.OEqP;
import com.xk72.proxy.Fields;
import com.xk72.proxy.ProxyEventStatus;
import com.xk72.proxy.ProxyException;
import com.xk72.proxy.http.HttpFields;
import com.xk72.proxy.http2.Http2Fields;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Base64;
import java.util.logging.Logger;

public class voUH
extends eaPA {
    private static final Logger XdKP = Logger.getLogger("com.xk72.charles.export.SessionJSONImporter");

    @Override
    public Session XdKP(File file, Session session) {
        Session session2 = session != null ? session : new Session();
        OEqP oEqP = new OEqP(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        oEqP.beginArray();
        while (oEqP.hasNext()) {
            Transaction transaction = this.XdKP(oEqP);
            session2.addTransaction(transaction);
        }
        oEqP.endArray();
        return session2;
    }

    private Transaction XdKP(OEqP oEqP) {
        oEqP.beginObject();
        Transaction transaction = new Transaction();
        while (oEqP.hasNext()) {
            String string = oEqP.nextName();
            if ("status".equals(string)) {
                String string2 = oEqP.XdKP();
                if (string2 != null) {
                    try {
                        transaction.setStatus(ProxyEventStatus.valueOf(string2));
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        try {
                            transaction.setStatus(Transaction.XdKP(string2));
                            continue;
                        }
                        catch (IllegalArgumentException illegalArgumentException2) {
                            throw illegalArgumentException;
                        }
                    }
                }
                transaction.setStatus(null);
                continue;
            }
            if ("method".equals(string)) {
                transaction.setMethod(oEqP.XdKP());
                continue;
            }
            if ("protocolVersion".equals(string)) {
                transaction.setProtocolVersion(oEqP.XdKP());
                continue;
            }
            if ("scheme".equals(string)) {
                transaction.setProtocol(oEqP.XdKP());
                continue;
            }
            if ("host".equals(string)) {
                transaction.setHost(oEqP.XdKP());
                continue;
            }
            if ("port".equals(string)) {
                transaction.setPort(oEqP.XdKP(-1));
                continue;
            }
            if ("actualPort".equals(string)) {
                transaction.setActualPort(oEqP.nextInt());
                continue;
            }
            if ("path".equals(string)) {
                transaction.setPath(oEqP.XdKP());
                continue;
            }
            if ("query".equals(string)) {
                transaction.setQuery(oEqP.XdKP());
                continue;
            }
            if ("remoteAddress".equals(string)) {
                transaction.setRemoteAddress(this.eCYm(oEqP.XdKP()));
                continue;
            }
            if ("clientAddress".equals(string)) {
                transaction.setClientAddress(this.eCYm(oEqP.XdKP()));
                continue;
            }
            if ("times".equals(string)) {
                this.XdKP(oEqP, transaction);
                continue;
            }
            if ("durations".equals(string)) {
                this.eCYm(oEqP, transaction);
                continue;
            }
            if ("speeds".equals(string)) {
                oEqP.skipValue();
                continue;
            }
            if ("totalSize".equals(string)) {
                oEqP.skipValue();
                continue;
            }
            if ("ssl".equals(string)) {
                this.uQqp(oEqP, transaction);
                continue;
            }
            if ("alpn".equals(string)) {
                this.AhDU(oEqP, transaction);
                continue;
            }
            if ("request".equals(string)) {
                this.PRdh(oEqP, transaction);
                continue;
            }
            if ("response".equals(string)) {
                this.Vvaz(oEqP, transaction);
                continue;
            }
            if ("tunnel".equals(string)) {
                transaction.setTunnel(oEqP.nextBoolean());
                continue;
            }
            if ("keptAlive".equals(string)) {
                transaction.setKeptAlive(oEqP.nextBoolean());
                continue;
            }
            if ("webSocket".equals(string)) {
                transaction.setWebSocket(oEqP.nextBoolean());
                continue;
            }
            if ("notes".equals(string)) {
                transaction.setNotes(oEqP.nextString());
                continue;
            }
            if ("exception".equals(string)) {
                transaction.setException(new ProxyException(oEqP.nextString()));
                continue;
            }
            XdKP.warning("Ignoring transaction key: " + string);
            oEqP.skipValue();
        }
        oEqP.endObject();
        return transaction;
    }

    private void XdKP(OEqP oEqP, Transaction transaction) {
        oEqP.beginObject();
        while (oEqP.hasNext()) {
            String string = oEqP.nextName();
            if ("start".equals(string)) {
                transaction.setStartTime(this.uQqp(oEqP.XdKP()));
                continue;
            }
            if ("requestBegin".equals(string)) {
                transaction.setRequestBeginTime(this.uQqp(oEqP.XdKP()));
                continue;
            }
            if ("requestComplete".equals(string)) {
                transaction.setRequestCompleteTime(this.uQqp(oEqP.XdKP()));
                continue;
            }
            if ("responseBegin".equals(string)) {
                transaction.setResponseBeginTime(this.uQqp(oEqP.XdKP()));
                continue;
            }
            if ("end".equals(string)) {
                transaction.setEndTime(this.uQqp(oEqP.XdKP()));
                continue;
            }
            XdKP.warning("Ignoring times key: " + string);
            oEqP.skipValue();
        }
        oEqP.endObject();
    }

    private void eCYm(OEqP oEqP, Transaction transaction) {
        oEqP.beginObject();
        while (oEqP.hasNext()) {
            String string = oEqP.nextName();
            if ("total".equals(string) || "request".equals(string) || "response".equals(string) || "latency".equals(string)) {
                oEqP.skipValue();
                continue;
            }
            if ("dns".equals(string)) {
                transaction.setDnsDuration(oEqP.uQqp());
                continue;
            }
            if ("connect".equals(string)) {
                transaction.setConnectDuration(oEqP.uQqp());
                continue;
            }
            if ("ssl".equals(string)) {
                transaction.setSslDuration(oEqP.uQqp());
                continue;
            }
            if ("end".equals(string)) {
                transaction.setEndTime(this.uQqp(oEqP.XdKP()));
                continue;
            }
            XdKP.warning("Ignoring durations key: " + string);
            oEqP.skipValue();
        }
        oEqP.endObject();
    }

    private void uQqp(OEqP oEqP, Transaction transaction) {
        oEqP.beginObject();
        while (oEqP.hasNext()) {
            String string = oEqP.nextName();
            if ("protocol".equals(string)) {
                transaction.setSslProtocol(oEqP.XdKP());
                continue;
            }
            if ("cipherSuite".equals(string)) {
                transaction.setCipherSuite(oEqP.XdKP());
                continue;
            }
            XdKP.warning("Ignoring SSL key: " + string);
            oEqP.skipValue();
        }
        oEqP.endObject();
    }

    private void AhDU(OEqP oEqP, Transaction transaction) {
        oEqP.beginObject();
        while (oEqP.hasNext()) {
            String string = oEqP.nextName();
            if ("protocol".equals(string)) {
                transaction.setAlpnProtocol(oEqP.XdKP());
                continue;
            }
            XdKP.warning("Ignoring ALPN key: " + string);
            oEqP.skipValue();
        }
        oEqP.endObject();
    }

    private void PRdh(OEqP oEqP, Transaction transaction) {
        oEqP.beginObject();
        while (oEqP.hasNext()) {
            String string = oEqP.nextName();
            if ("sizes".equals(string)) {
                this.Idso(oEqP, transaction);
                continue;
            }
            if ("mimeType".equals(string) || "charset".equals(string) || "contentEncoding".equals(string)) {
                oEqP.skipValue();
                continue;
            }
            if ("header".equals(string)) {
                transaction.setRequestHeader(this.XdKP(oEqP, transaction.getProtocolVersion()));
                continue;
            }
            if ("body".equals(string)) {
                MfoV mfoV = this.eCYm(oEqP);
                transaction.setRequestBody(mfoV.XdKP);
                transaction.setRequestBodyDecoded(mfoV.eCYm);
                continue;
            }
            XdKP.warning("Ignoring request key: " + string);
            oEqP.skipValue();
        }
        oEqP.endObject();
    }

    private void Idso(OEqP oEqP, Transaction transaction) {
        oEqP.beginObject();
        while (oEqP.hasNext()) {
            String string = oEqP.nextName();
            if ("headers".equals(string)) {
                transaction.setRequestHeaderSize(oEqP.nextInt());
                continue;
            }
            if ("body".equals(string)) {
                transaction.setRequestSize(oEqP.nextLong());
                continue;
            }
            if ("handshake".equals(string)) {
                transaction.setRequestHandshakeSize(oEqP.nextInt());
                continue;
            }
            XdKP.warning("Ignoring request size key: " + string);
            oEqP.skipValue();
        }
        oEqP.endObject();
    }

    private void Vvaz(OEqP oEqP, Transaction transaction) {
        oEqP.beginObject();
        while (oEqP.hasNext()) {
            String string = oEqP.nextName();
            if ("sizes".equals(string)) {
                this.Hylk(oEqP, transaction);
                continue;
            }
            if ("status".equals(string) || "mimeType".equals(string) || "charset".equals(string) || "contentEncoding".equals(string)) {
                oEqP.skipValue();
                continue;
            }
            if ("header".equals(string)) {
                transaction.setResponseHeader(this.XdKP(oEqP, transaction.getProtocolVersion()));
                continue;
            }
            if ("body".equals(string)) {
                MfoV mfoV = this.eCYm(oEqP);
                transaction.setResponseBody(mfoV.XdKP);
                transaction.setResponseBodyDecoded(mfoV.eCYm);
                continue;
            }
            XdKP.warning("Ignoring response key: " + string);
            oEqP.skipValue();
        }
        oEqP.endObject();
    }

    private void Hylk(OEqP oEqP, Transaction transaction) {
        oEqP.beginObject();
        while (oEqP.hasNext()) {
            String string = oEqP.nextName();
            if ("headers".equals(string)) {
                transaction.setResponseHeaderSize(oEqP.nextInt());
                continue;
            }
            if ("body".equals(string)) {
                transaction.setResponseSize(oEqP.nextLong());
                continue;
            }
            if ("handshake".equals(string)) {
                transaction.setResponseHandshakeSize(oEqP.nextInt());
                continue;
            }
            XdKP.warning("Ignoring response size key: " + string);
            oEqP.skipValue();
        }
        oEqP.endObject();
    }

    private HttpFields XdKP(OEqP oEqP, String string) {
        HttpFields httpFields = "HTTP/2.0".equals(string) ? new Http2Fields() : new HttpFields();
        oEqP.beginObject();
        while (oEqP.hasNext()) {
            String string2 = oEqP.nextName();
            if ("firstLine".equals(string2)) {
                httpFields.setFirstLine(oEqP.XdKP());
                continue;
            }
            if ("headers".equals(string2)) {
                oEqP.beginArray();
                while (oEqP.hasNext()) {
                    this.XdKP(oEqP, httpFields);
                }
                oEqP.endArray();
                continue;
            }
            XdKP.warning("Ignoring header key: " + string2);
            oEqP.skipValue();
        }
        oEqP.endObject();
        return httpFields;
    }

    private void XdKP(OEqP oEqP, Fields fields) {
        String string = null;
        String string2 = null;
        oEqP.beginObject();
        while (oEqP.hasNext()) {
            String string3 = oEqP.nextName();
            if ("name".equals(string3)) {
                string = oEqP.XdKP();
                continue;
            }
            if ("value".equals(string3)) {
                string2 = oEqP.XdKP();
                continue;
            }
            XdKP.warning("Ignoring header line key: " + string3);
            oEqP.skipValue();
        }
        oEqP.endObject();
        if (string != null) {
            fields.addField(string, string2);
        }
    }

    private MfoV eCYm(OEqP oEqP) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        oEqP.beginObject();
        while (oEqP.hasNext()) {
            String string5 = oEqP.nextName();
            if ("text".equals(string5)) {
                string4 = oEqP.XdKP();
                continue;
            }
            if ("charset".equals(string5)) {
                string3 = oEqP.XdKP();
                continue;
            }
            if ("encoding".equals(string5)) {
                string = oEqP.XdKP();
                continue;
            }
            if ("encoded".equals(string5)) {
                string2 = oEqP.XdKP();
                continue;
            }
            if ("decoded".equals(string5)) {
                bl = oEqP.nextBoolean();
                continue;
            }
            XdKP.warning("Ignoring header key: " + string5);
            oEqP.skipValue();
        }
        oEqP.endObject();
        if (string4 != null) {
            return new MfoV(mukF.eCYm(string3, string4), bl);
        }
        if (string != null) {
            if ("base64".equals(string)) {
                return new MfoV(Base64.getDecoder().decode(string2), bl);
            }
            throw new IllegalStateException("Unsupported body encoding: " + string);
        }
        return null;
    }
}

