/*
 * Decompiled with CFR 0.152.
 */
package com.xk72.charles.config;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.xk72.charles.CharlesContext;
import com.xk72.charles.config.AbstractLegacySupportConfiguration;
import com.xk72.charles.config.CharlesConfiguration;
import com.xk72.charles.config.LocationPatternConfiguration;
import com.xk72.charles.config.ProxyConfiguration$IntegrationConfiguration;
import com.xk72.charles.ssl.CertificateConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;

@XStreamAlias(value="proxy")
public class ProxyConfiguration
extends AbstractLegacySupportConfiguration {
    private boolean enableSOCKSProxy = false;
    private boolean dynamicHTTPPort = false;
    private boolean dynamicSOCKSPort = false;
    private boolean enableSOCKSTransparentHTTPProxying = true;
    private int port = 8888;
    private int SOCKSPort = 8889;
    private boolean decryptSSL = true;
    private boolean transparentProxy = false;
    private boolean supportsH2 = true;
    private String firefoxProfilePath;
    private boolean preferIPv6addresses = false;
    private List<String> bypassDomains;
    private LocationPatternConfiguration sslLocations = new LocationPatternConfiguration();
    private LocationPatternConfiguration sslExcludeLocations = new LocationPatternConfiguration();
    private CertificateConfiguration sslRootCertificate;
    private boolean defaultSOCKSTransparentHTTPProxyPorts = true;
    private int[] socksTransparentHTTPProxyPorts;
    private int[] socksTransparentHTTPProxyPortRanges;
    private ProxyConfiguration$IntegrationConfiguration windowsConfiguration = new ProxyConfiguration$IntegrationConfiguration();
    private ProxyConfiguration$IntegrationConfiguration macOSXConfiguration = new ProxyConfiguration$IntegrationConfiguration();
    private ProxyConfiguration$IntegrationConfiguration mozillaFirefoxConfiguration = new ProxyConfiguration$IntegrationConfiguration();

    @Override
    public void init(CharlesConfiguration charlesConfiguration) {
        super.init(charlesConfiguration);
        if (System.getProperty("charles.proxyPort") != null) {
            try {
                this.port = Integer.parseInt(System.getProperty("charles.proxyPort"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (System.getProperty("charles.socksProxyPort") != null) {
            try {
                this.SOCKSPort = Integer.parseInt(System.getProperty("charles.socksProxyPort"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.sslLocations.XdKP();
    }

    @Override
    public void loadLegacyProperties(Properties properties) {
        this.setPort(this.getIntProperty(properties, "proxyPort", this.getPort()));
        this.setAutoConfigureWindowsProxy(this.getBooleanProperty(properties, "win32AutoconfigureProxy", this.getWindowsConfiguration().isEnableAtStartup()));
        this.setDecryptSSL(this.getBooleanProperty(properties, "proxySSL", this.isDecryptSSL()));
    }

    public boolean isDecryptSSL() {
        return this.decryptSSL;
    }

    public void setDecryptSSL(boolean bl) {
        boolean bl2 = this.decryptSSL;
        this.decryptSSL = bl;
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange("decryptSSL", bl2, bl);
        }
    }

    public LocationPatternConfiguration getSSLLocations() {
        return this.sslLocations;
    }

    public void setSSLLocations(LocationPatternConfiguration locationPatternConfiguration) {
        this.sslLocations = locationPatternConfiguration;
    }

    public LocationPatternConfiguration getSSLExcludeLocations() {
        return this.sslExcludeLocations;
    }

    public void setSSLExcludeLocations(LocationPatternConfiguration locationPatternConfiguration) {
        this.sslExcludeLocations = locationPatternConfiguration;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        int n2 = this.port;
        this.port = n;
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange("port", n2, n);
        }
    }

    @Deprecated
    public void setAutoConfigureWindowsProxy(boolean bl) {
        this.getWindowsConfiguration().setEnableAtStartup(bl);
    }

    @Deprecated
    public void setAutoConfigureMacOSXProxy(boolean bl) {
        this.getMacOSXConfiguration().setEnableAtStartup(bl);
    }

    @Deprecated
    public void setAutoConfigureFirefoxProxy(boolean bl) {
        this.getMozillaFirefoxConfiguration().setEnableAtStartup(bl);
    }

    public List<String> getBypassDomains() {
        return this.bypassDomains;
    }

    public void setBypassDomains(List<String> list) {
        this.bypassDomains = list;
    }

    public int getSOCKSPort() {
        return this.SOCKSPort;
    }

    public void setSOCKSPort(int n) {
        this.SOCKSPort = n;
    }

    @Deprecated
    public void setDynamicPorts(boolean bl) {
        this.dynamicHTTPPort = bl;
        this.dynamicSOCKSPort = bl;
    }

    @Deprecated
    public boolean isPreferIPv6addresses() {
        return this.preferIPv6addresses;
    }

    @Deprecated
    public void setPreferIPv6addresses(boolean bl) {
        this.preferIPv6addresses = bl;
    }

    public String getFirefoxProfilePath() {
        return this.firefoxProfilePath;
    }

    public void setFirefoxProfilePath(String string) {
        this.firefoxProfilePath = string;
    }

    public boolean isDynamicSOCKSPort() {
        return this.dynamicSOCKSPort;
    }

    public void setDynamicSOCKSPort(boolean bl) {
        this.dynamicSOCKSPort = bl;
    }

    public boolean isDynamicHTTPPort() {
        return this.dynamicHTTPPort;
    }

    public void setDynamicHTTPPort(boolean bl) {
        this.dynamicHTTPPort = bl;
    }

    public boolean isEnableSOCKSProxy() {
        return this.enableSOCKSProxy;
    }

    public void setEnableSOCKSProxy(boolean bl) {
        this.enableSOCKSProxy = bl;
    }

    public boolean isEnableSOCKSTransparentHTTPProxying() {
        return this.enableSOCKSTransparentHTTPProxying;
    }

    public void setEnableSOCKSTransparentHTTPProxying(boolean bl) {
        boolean bl2 = this.enableSOCKSTransparentHTTPProxying;
        this.enableSOCKSTransparentHTTPProxying = bl;
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange("enableSOCKSTransparentHTTPProxying", bl2, bl);
        }
    }

    public boolean isDefaultSOCKSTransparentHTTPProxyPorts() {
        return this.defaultSOCKSTransparentHTTPProxyPorts;
    }

    public void setDefaultSOCKSTransparentHTTPProxyPorts(boolean bl) {
        boolean bl2 = this.defaultSOCKSTransparentHTTPProxyPorts;
        this.defaultSOCKSTransparentHTTPProxyPorts = bl;
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange("defaultSOCKSTransparentHTTPProxyPorts", bl2, bl);
        }
    }

    public int[] getSocksTransparentHTTPProxyPorts() {
        return this.socksTransparentHTTPProxyPorts;
    }

    public void setSocksTransparentHTTPProxyPorts(int[] nArray) {
        int[] nArray2 = this.socksTransparentHTTPProxyPorts;
        this.socksTransparentHTTPProxyPorts = nArray;
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange("socksTransparentHTTPProxyPorts", nArray2, nArray);
        }
    }

    public int[] getSocksTransparentHTTPProxyPortRanges() {
        return this.socksTransparentHTTPProxyPortRanges;
    }

    public void setSocksTransparentHTTPProxyPortRanges(int[] nArray) {
        int[] nArray2 = this.socksTransparentHTTPProxyPortRanges;
        this.socksTransparentHTTPProxyPortRanges = nArray;
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange("socksTransparentHTTPProxyPortRanges", nArray2, nArray);
        }
    }

    public ProxyConfiguration$IntegrationConfiguration getWindowsConfiguration() {
        return this.windowsConfiguration;
    }

    public void setWindowsConfiguration(ProxyConfiguration$IntegrationConfiguration proxyConfiguration$IntegrationConfiguration) {
        this.windowsConfiguration = proxyConfiguration$IntegrationConfiguration;
    }

    public ProxyConfiguration$IntegrationConfiguration getMacOSXConfiguration() {
        return this.macOSXConfiguration;
    }

    public void setMacOSXConfiguration(ProxyConfiguration$IntegrationConfiguration proxyConfiguration$IntegrationConfiguration) {
        this.macOSXConfiguration = proxyConfiguration$IntegrationConfiguration;
    }

    public ProxyConfiguration$IntegrationConfiguration getMozillaFirefoxConfiguration() {
        return this.mozillaFirefoxConfiguration;
    }

    public void setMozillaFirefoxConfiguration(ProxyConfiguration$IntegrationConfiguration proxyConfiguration$IntegrationConfiguration) {
        this.mozillaFirefoxConfiguration = proxyConfiguration$IntegrationConfiguration;
    }

    @Deprecated
    public String getSSLCACertificatePath() {
        return null;
    }

    @Deprecated
    public void setSSLCACertificatePath(String string) {
        try {
            File file = new File(string);
            String string2 = CharlesContext.getInstance().getFileStore().XdKP(file);
            this.sslRootCertificate = new CertificateConfiguration(file.getName(), string2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public CertificateConfiguration getSSLRootCertificate() {
        return this.sslRootCertificate;
    }

    public void setSSLRootCertificate(CertificateConfiguration certificateConfiguration) {
        CertificateConfiguration certificateConfiguration2 = this.sslRootCertificate;
        this.sslRootCertificate = certificateConfiguration;
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange("sslRootCertificate", certificateConfiguration2, certificateConfiguration);
        }
    }

    public boolean isTransparentProxy() {
        return this.transparentProxy;
    }

    public void setTransparentProxy(boolean bl) {
        boolean bl2 = this.transparentProxy;
        this.transparentProxy = bl;
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange("transparentProxy", bl2, bl);
        }
    }

    public boolean isSupportsH2() {
        return this.supportsH2;
    }

    public void setSupportsH2(boolean bl) {
        boolean bl2 = this.supportsH2;
        this.supportsH2 = bl;
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange("supportsH2", bl2, bl);
        }
    }
}

